/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;
import org.eclipse.jkube.kit.common.util.Serialization;
import org.eclipse.jkube.kit.common.util.UserConfigurationCompare;
import org.eclipse.jkube.kit.config.service.JKubeServiceHub;
import org.eclipse.jkube.kit.config.service.PatchService;
import org.eclipse.jkube.kit.config.service.ingresscontroller.IngressControllerDetectorManager;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class ApplyService {
    private final KubernetesClient kubernetesClient;
    private final KitLogger log;
    private boolean allowCreate = true;
    private boolean servicesOnlyMode;
    private boolean ignoreServiceMode;
    private boolean ignoreRunningOAuthClients = true;
    private boolean ignoreBoundPersistentVolumeClaims = true;
    private boolean rollingUpgrade;
    private boolean processTemplatesLocally;
    private File logJsonDir;
    private File basedir;
    private boolean supportOAuthClients;
    private boolean deletePodsOnReplicationControllerUpdate = true;
    private String namespace = KubernetesHelper.getDefaultNamespace();
    private String fallbackNamespace;
    private boolean rollingUpgradePreserveScale = true;
    private boolean recreateMode;
    private final PatchService patchService;
    private final IngressControllerDetectorManager ingressControllerDetectorManager;
    private static final Set<String> projectsCreated = new HashSet<String>();

    ApplyService(JKubeServiceHub serviceHub) {
        this.kubernetesClient = serviceHub.getClient();
        this.log = serviceHub.getLog();
        this.patchService = new PatchService(this.kubernetesClient);
        this.ingressControllerDetectorManager = new IngressControllerDetectorManager(serviceHub);
    }

    public void apply(Object dto, String fileName) {
        if (dto instanceof List) {
            List list = (List)dto;
            for (Object element : list) {
                if (dto == element) {
                    this.log.warn("Found recursive nested object for %s of class: %s", new Object[]{dto, dto.getClass().getName()});
                    continue;
                }
                this.apply(element, fileName);
            }
        } else if (dto instanceof KubernetesList) {
            this.applyList((KubernetesList)dto, fileName);
        } else if (dto != null) {
            this.applyEntity(dto, fileName);
        }
    }

    public boolean isAlreadyApplied(HasMetadata resource) {
        return this.kubernetesClient.resource(resource).inNamespace(KubernetesClientUtil.applicableNamespace(resource, this.namespace, this.fallbackNamespace)).get() != null;
    }

    private void applyEntity(Object dto, String sourceName) {
        if (dto instanceof ReplicationController) {
            this.applyReplicationController((ReplicationController)dto, sourceName);
        } else if (dto instanceof Route) {
            this.applyRoute((Route)dto, sourceName);
        } else if (dto instanceof BuildConfig) {
            this.applyBuildConfig((BuildConfig)dto, sourceName);
        } else if (dto instanceof DeploymentConfig) {
            DeploymentConfig resource = (DeploymentConfig)dto;
            if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
                this.applyResource(resource, sourceName);
            } else {
                this.log.warn("Not connected to OpenShift cluster so cannot apply entity %s", new Object[]{dto});
            }
        } else if (dto instanceof ImageStream) {
            this.applyImageStream((ImageStream)dto, sourceName);
        } else if (dto instanceof OAuthClient) {
            this.applyOAuthClient((OAuthClient)dto, sourceName);
        } else if (dto instanceof Template) {
            this.applyTemplate((Template)dto, sourceName);
        } else if (dto instanceof Ingress) {
            this.applyResource((Ingress)dto, sourceName);
            this.ingressControllerDetectorManager.detect();
        } else if (dto instanceof io.fabric8.kubernetes.api.model.networking.v1.Ingress) {
            this.applyResource((io.fabric8.kubernetes.api.model.networking.v1.Ingress)dto, sourceName);
            this.ingressControllerDetectorManager.detect();
        } else if (dto instanceof PersistentVolumeClaim) {
            this.applyPersistentVolumeClaim((PersistentVolumeClaim)dto, sourceName);
        } else if (dto instanceof Job) {
            this.applyJob((Job)dto, sourceName);
        } else if (dto instanceof Namespace) {
            this.applyNamespace((Namespace)dto);
        } else if (dto instanceof Project) {
            this.applyProject((Project)dto);
        } else if (dto instanceof GenericKubernetesResource) {
            this.applyGenericKubernetesResource((GenericKubernetesResource)dto, sourceName);
        } else if (dto instanceof HasMetadata) {
            this.applyResource((HasMetadata)dto, sourceName);
        } else {
            throw new IllegalArgumentException("Unknown entity type " + dto);
        }
    }

    public void applyGenericKubernetesResource(GenericKubernetesResource genericKubernetesResource, String sourceName) {
        GenericKubernetesResource existentCR;
        String name = genericKubernetesResource.getMetadata().getName();
        String applyNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)genericKubernetesResource, this.namespace, this.fallbackNamespace);
        String apiGroupWithKind = KubernetesHelper.getFullyQualifiedApiGroupWithKind((HasMetadata)genericKubernetesResource);
        Objects.requireNonNull(name, "No name for " + genericKubernetesResource + " " + sourceName);
        if (this.isRecreateMode()) {
            this.log.info("Attempting to delete Custom Resource: %s %s/%s", new Object[]{apiGroupWithKind, this.namespace, name});
            KubernetesClientUtil.doDeleteAndWait(this.kubernetesClient, genericKubernetesResource, applyNamespace, 10L);
        }
        if ((existentCR = KubernetesClientUtil.doGetCustomResource(this.kubernetesClient, genericKubernetesResource, applyNamespace)) != null && StringUtils.isBlank((CharSequence)existentCR.getMetadata().getDeletionTimestamp())) {
            this.log.info("Replacing Custom Resource: %s %s/%s", new Object[]{apiGroupWithKind, applyNamespace, name});
            genericKubernetesResource.getMetadata().setResourceVersion(existentCR.getMetadata().getResourceVersion());
        }
        ((Resource)((NonNamespaceOperation)this.kubernetesClient.genericKubernetesResources(genericKubernetesResource.getApiVersion(), genericKubernetesResource.getKind()).inNamespace(applyNamespace)).withName(name)).createOrReplace((Object)genericKubernetesResource);
        this.log.info("Created Custom Resource: %s %s/%s", new Object[]{apiGroupWithKind, applyNamespace, name});
    }

    public void applyOAuthClient(OAuthClient entity, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient) && this.supportOAuthClients) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring OAuthClient: %s", new Object[]{id});
                return;
            }
            OpenShiftClient openShiftClient = this.asOpenShiftClient();
            OAuthClient old = (OAuthClient)((Resource)openShiftClient.oAuthClients().withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (this.isIgnoreRunningOAuthClients()) {
                    this.log.info("Not updating the OAuthClient which are shared across namespaces as its already running", new Object[0]);
                    return;
                }
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("OAuthClient has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    ((Resource)openShiftClient.oAuthClients().withName(id)).delete();
                    this.doCreateOAuthClient(entity, sourceName);
                } else {
                    try {
                        Object answer = ((Resource)openShiftClient.oAuthClients().withName(id)).replace((Object)entity);
                        this.log.info("Updated OAuthClient result: %s", new Object[]{answer});
                    }
                    catch (Exception e) {
                        this.onApplyError("Failed to update OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating an OAuthClient from %s name %s", new Object[]{sourceName, KubernetesHelper.getName((HasMetadata)entity)});
            } else {
                this.doCreateOAuthClient(entity, sourceName);
            }
        }
    }

    protected void doCreateOAuthClient(OAuthClient entity, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            try {
                ((Resource)this.asOpenShiftClient().oAuthClients().resource((Object)entity)).create();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create OAuthClient from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public Object applyTemplate(Template entity, String sourceName) {
        this.installTemplate(entity, sourceName);
        return this.processTemplate(entity, sourceName);
    }

    public void installTemplate(Template entity, String sourceName) {
        if (!OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            return;
        }
        if (!this.isProcessTemplatesLocally()) {
            OpenShiftClient openShiftClient = this.asOpenShiftClient();
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            Template old = (Template)((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("Template has not changed so not doing anything", new Object[0]);
                } else {
                    boolean recreateMode = this.isRecreateMode();
                    recreateMode = true;
                    if (recreateMode) {
                        ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).delete();
                        this.doCreateTemplate(entity, currentNamespace, sourceName);
                    } else {
                        this.log.info("Updating a Template from %s", new Object[]{sourceName});
                        try {
                            Object answer = ((TemplateResource)((NonNamespaceOperation)openShiftClient.templates().inNamespace(currentNamespace)).withName(id)).replace((Object)entity);
                            this.log.info("Updated Template: " + answer, new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update Template from " + sourceName + ". " + e + ". " + entity, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a Template from %s namespace %s name %s", new Object[]{sourceName, currentNamespace, KubernetesHelper.getName((HasMetadata)entity)});
            } else {
                this.doCreateTemplate(entity, currentNamespace, sourceName);
            }
        }
    }

    private OpenShiftClient asOpenShiftClient() {
        return OpenshiftHelper.asOpenShiftClient((KubernetesClient)this.kubernetesClient);
    }

    protected void doCreateTemplate(Template entity, String namespace, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            this.log.info("Creating a Template from " + sourceName + " namespace " + namespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            try {
                Template answer = (Template)((NonNamespaceOperation)this.asOpenShiftClient().templates().inNamespace(namespace)).create((Object)entity);
                this.logGeneratedEntity("Created Template: ", namespace, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to Template entity from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyPersistentVolumeClaim(PersistentVolumeClaim entity, String sourceName) {
        boolean alwaysRecreate = true;
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring PersistentVolumeClaim: " + id, new Object[0]);
            return;
        }
        PersistentVolumeClaim old = (PersistentVolumeClaim)((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(currentNamespace)).withName(id)).get();
        if (this.isRunning((HasMetadata)old)) {
            if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                this.log.info("PersistentVolumeClaim has not changed so not doing anything", new Object[0]);
            } else if (alwaysRecreate || this.isRecreateMode()) {
                if (!this.isRecreateMode() && this.isIgnoreBoundPersistentVolumeClaims() && this.isBound(old)) {
                    this.log.warn("PersistentVolumeClaim " + id + " in namespace " + currentNamespace + " is already bound and will not be replaced with the new one from " + sourceName, new Object[0]);
                } else {
                    this.log.info("Deleting PersistentVolumeClaim from namespace " + currentNamespace + " with name " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(currentNamespace)).withName(id)).delete();
                    this.log.info("Deleted PersistentVolumeClaim from namespace " + currentNamespace + " with name " + id, new Object[0]);
                    this.doCreate((HasMetadata)entity, currentNamespace, sourceName);
                }
            } else {
                this.doPatchEntity(old, entity, currentNamespace, sourceName);
            }
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a %s from %s in namespace %s with name %s", new Object[]{"PersistentVolumeClaim", sourceName, currentNamespace, id});
        } else {
            this.doCreate((HasMetadata)entity, currentNamespace, sourceName);
        }
    }

    protected boolean isBound(PersistentVolumeClaim claim) {
        return claim != null && claim.getStatus() != null && "Bound".equals(claim.getStatus().getPhase());
    }

    private void logGeneratedEntity(String message, String namespace, HasMetadata entity, Object result) {
        if (this.logJsonDir != null) {
            File directory = StringUtils.isBlank((CharSequence)namespace) ? this.logJsonDir : new File(this.logJsonDir, namespace);
            directory.mkdirs();
            String kind = KubernetesHelper.getKind((KubernetesResource)entity);
            String name = KubernetesHelper.getName((HasMetadata)entity);
            if (StringUtils.isNotBlank((CharSequence)kind)) {
                name = kind.toLowerCase() + "-" + name;
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.log.warn("No name for the entity " + entity, new Object[0]);
            } else {
                String text;
                String fileName = name + ".json";
                File file = new File(directory, fileName);
                if (file.exists()) {
                    int idx = 1;
                    while ((file = new File(directory, fileName = name + "-" + idx++ + ".json")).exists()) {
                    }
                }
                if (result instanceof String) {
                    text = result.toString();
                } else {
                    try {
                        text = Serialization.asJson((Object)result);
                    }
                    catch (Exception e) {
                        this.log.warn("Cannot convert " + result + " to JSON: " + e, new Object[]{e});
                        text = result != null ? result.toString() : "null";
                    }
                }
                try {
                    String path;
                    FileUtils.writeStringToFile((File)file, (String)text, (Charset)Charset.defaultCharset());
                    Object fileLocation = file;
                    if (this.basedir != null && (path = FileUtil.getRelativePath((File)this.basedir, (File)file).getPath()) != null) {
                        fileLocation = FileUtil.stripPrefix((String)path, (String)"/");
                    }
                    this.log.info(message + fileLocation, new Object[0]);
                }
                catch (IOException e) {
                    this.log.warn("Failed to write to file " + file + ". " + e, new Object[]{e});
                }
                return;
            }
        }
        this.log.info(message + result, new Object[0]);
    }

    public Object processTemplate(Template entity, String sourceName) {
        try {
            return OpenshiftHelper.processTemplatesLocally((Template)entity, (boolean)false);
        }
        catch (Exception e) {
            this.onApplyError("Failed to process template " + sourceName + ". " + e + ". " + entity, e);
            return null;
        }
    }

    public void applyRoute(Route entity, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Ignoring Route: " + currentNamespace + ":" + id, new Object[0]);
                return;
            }
            OpenShiftClient openShiftClient = this.asOpenShiftClient();
            Route route = (Route)((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)route)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)route)) {
                    this.log.info("Route has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting Route: " + id, new Object[0]);
                    ((Resource)((NonNamespaceOperation)openShiftClient.routes().inNamespace(currentNamespace)).withName(id)).delete();
                    this.doCreateRoute(entity, currentNamespace, sourceName);
                } else {
                    this.doPatchEntity(route, entity, currentNamespace, sourceName);
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a Route from " + sourceName + " namespace " + currentNamespace + " name " + id, new Object[0]);
            } else {
                this.doCreateRoute(entity, currentNamespace, sourceName);
            }
        }
    }

    private void doCreateRoute(Route entity, String namespace, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            try {
                this.log.info("Creating Route " + namespace + ":" + id + " " + (entity.getSpec() != null ? "host: " + entity.getSpec().getHost() : "No Spec !"), new Object[0]);
                ((Resource)((NonNamespaceOperation)this.asOpenShiftClient().routes().inNamespace(namespace)).resource((Object)entity)).create();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create Route from " + sourceName + ". " + e + ". " + entity, e);
            }
        }
    }

    public void applyBuildConfig(BuildConfig entity, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            String id = KubernetesHelper.getName((HasMetadata)entity);
            Objects.requireNonNull(id, "No name for " + entity + " " + sourceName);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            this.applyNamespace(currentNamespace);
            OpenShiftClient openShiftClient = this.asOpenShiftClient();
            BuildConfig old = (BuildConfig)((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)entity, (Object)old)) {
                    this.log.info("BuildConfig has not changed so not doing anything", new Object[0]);
                } else if (this.isRecreateMode()) {
                    this.log.info("Deleting BuildConfig: " + id, new Object[0]);
                    ((BuildConfigResource)((NonNamespaceOperation)openShiftClient.buildConfigs().inNamespace(currentNamespace)).withName(id)).delete();
                    this.doCreateBuildConfig(entity, currentNamespace, sourceName);
                } else {
                    this.doPatchEntity(old, entity, currentNamespace, sourceName);
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating BuildConfig from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            } else {
                this.doCreateBuildConfig(entity, currentNamespace, sourceName);
            }
        }
    }

    public void doCreateBuildConfig(BuildConfig entity, String namespace, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            try {
                ((BuildConfigResource)((NonNamespaceOperation)this.asOpenShiftClient().buildConfigs().inNamespace(namespace)).resource((Object)entity)).create();
            }
            catch (Exception e) {
                this.onApplyError("Failed to create BuildConfig from " + sourceName + ". " + e, e);
            }
        }
    }

    public void applyImageStream(ImageStream entity, String sourceName) {
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            String kind = KubernetesHelper.getKind((KubernetesResource)entity);
            String name = KubernetesHelper.getName((HasMetadata)entity);
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)entity, this.namespace, this.fallbackNamespace);
            try {
                OpenShiftClient openShiftClient = this.asOpenShiftClient();
                Resource resource = (Resource)((NonNamespaceOperation)openShiftClient.imageStreams().inNamespace(currentNamespace)).withName(name);
                ImageStream old = (ImageStream)resource.get();
                if (old == null) {
                    this.log.info("Creating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    resource.create((Object)entity);
                } else {
                    this.log.info("Updating " + kind + " " + name + " from " + sourceName, new Object[0]);
                    this.copyAllImageStreamTags(entity, old);
                    entity = this.patchService.compareAndPatchEntity(currentNamespace, entity, old);
                    openShiftClient.resource((HasMetadata)entity).inNamespace(currentNamespace).createOrReplace();
                }
            }
            catch (Exception e) {
                this.onApplyError("Failed to create " + kind + " from " + sourceName + ". " + e, e);
            }
        }
    }

    protected void copyAllImageStreamTags(ImageStream from, ImageStream to) {
        List fromTags;
        ImageStreamSpec fromSpec;
        ArrayList<TagReference> toTags;
        ImageStreamSpec toSpec = to.getSpec();
        if (toSpec == null) {
            toSpec = new ImageStreamSpec();
            to.setSpec(toSpec);
        }
        if ((toTags = toSpec.getTags()) == null) {
            toTags = new ArrayList<TagReference>();
            toSpec.setTags(toTags);
        }
        if ((fromSpec = from.getSpec()) != null && (fromTags = fromSpec.getTags()) != null) {
            for (TagReference tag : fromTags) {
                this.removeTagByName(toTags, tag.getName());
            }
            for (TagReference tag : fromTags) {
                toTags.add(tag);
            }
        }
    }

    private int removeTagByName(List<TagReference> tags, String tagName) {
        ArrayList<TagReference> removeTags = new ArrayList<TagReference>();
        for (TagReference tag : tags) {
            if (!Objects.equals(tagName, tag.getName())) continue;
            removeTags.add(tag);
        }
        tags.removeAll(removeTags);
        return removeTags.size();
    }

    public void applyList(KubernetesList list, String sourceName) {
        List entities = list.getItems();
        if (entities != null) {
            for (Object entity : entities) {
                this.applyEntity(entity, sourceName);
            }
        }
    }

    public <T extends HasMetadata> void applyResource(T resource, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace(resource, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName(resource);
        String kind = KubernetesHelper.getKind(resource);
        Objects.requireNonNull(id, "No name for " + resource + " " + sourceName);
        if (this.isServicesOnlyMode() && !(resource instanceof Service)) {
            this.log.debug("Ignoring " + kind + ": " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        HasMetadata old = (HasMetadata)this.kubernetesClient.resource(resource).inNamespace(currentNamespace).get();
        if (this.isRunning(old)) {
            if (UserConfigurationCompare.configEqual(resource, (Object)old)) {
                this.log.info(kind + " has not changed so not doing anything", new Object[0]);
            } else if (this.isRecreateMode()) {
                this.log.info("Deleting " + kind + ": " + id, new Object[0]);
                this.kubernetesClient.resource(resource).inNamespace(currentNamespace).delete();
                this.doCreate(resource, currentNamespace, sourceName);
            } else {
                this.log.info("Updating " + kind + " from " + sourceName, new Object[0]);
                try {
                    HasMetadata updatedResource = (HasMetadata)this.kubernetesClient.resource(resource).inNamespace(currentNamespace).patch();
                    this.logGeneratedEntity("Updated " + kind + ": ", currentNamespace, resource, updatedResource);
                }
                catch (Exception e) {
                    this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + resource, e);
                }
            }
        } else if (!this.isAllowCreate() && resource instanceof Namespaced) {
            this.log.warn("Creation disabled so not creating a %s from %s in namespace %s with name %s", new Object[]{kind, sourceName, currentNamespace, id});
        } else if (!this.isAllowCreate()) {
            this.log.warn("Creation disabled so not creating a %s from %s with name %s", new Object[]{kind, sourceName, id});
        } else {
            this.doCreate(resource, currentNamespace, sourceName);
        }
    }

    private <T extends HasMetadata> void doPatchEntity(T oldEntity, T newEntity, String namespace, String sourceName) {
        String kind = newEntity.getKind();
        this.log.info("Updating %s from %s", new Object[]{kind, sourceName});
        try {
            T answer = this.patchService.compareAndPatchEntity(namespace, newEntity, oldEntity);
            this.logGeneratedEntity("Updated " + kind + ": ", namespace, newEntity, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to update " + kind + " from " + sourceName + ". " + e + ". " + newEntity, e);
        }
    }

    public boolean checkNamespace(String namespaceName) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return false;
        }
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            List projects = ((ProjectList)this.asOpenShiftClient().projects().list()).getItems();
            for (Project project : projects) {
                if (!namespaceName.equals(project.getMetadata().getName())) continue;
                return true;
            }
            return false;
        }
        return ((Resource)this.kubernetesClient.namespaces().withName(namespaceName)).get() != null;
    }

    public void applyNamespace(String namespaceName) {
        this.applyNamespace(namespaceName, null);
    }

    public void applyNamespace(String namespaceName, Map<String, String> labels) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return;
        }
        if (OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            ProjectRequest entity = new ProjectRequest();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String kubernetesClientNamespace = this.asOpenShiftClient().getNamespace();
            if (StringUtils.isNotBlank((CharSequence)kubernetesClientNamespace)) {
                Map entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", kubernetesClientNamespace);
                }
            }
            this.applyProjectRequest(entity);
        } else {
            Namespace entity = new Namespace();
            ObjectMeta metadata = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity);
            metadata.setName(namespaceName);
            String kubernetesClientNamespace = this.kubernetesClient.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)kubernetesClientNamespace)) {
                Map entityLabels = KubernetesHelper.getOrCreateLabels((HasMetadata)entity);
                if (labels != null) {
                    entityLabels.putAll(labels);
                } else {
                    entityLabels.put("project", kubernetesClientNamespace);
                }
            }
            this.applyNamespace(entity);
        }
    }

    public boolean applyNamespace(Namespace entity) {
        String currentNamespace = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        this.log.info("Creating currentNamespace: " + currentNamespace, new Object[0]);
        String name = KubernetesHelper.getName((HasMetadata)entity);
        Objects.requireNonNull(name, "No name for " + entity);
        Namespace old = (Namespace)((Resource)this.kubernetesClient.namespaces().withName(name)).get();
        if (!this.isRunning((HasMetadata)old)) {
            try {
                Object answer = this.kubernetesClient.namespaces().create((Object)entity);
                this.logGeneratedEntity("Created Namespace: ", currentNamespace, (HasMetadata)entity, answer);
                return true;
            }
            catch (Exception e) {
                this.onApplyError("Failed to create Namespace: " + name + " due " + e.getMessage(), e);
            }
        }
        return false;
    }

    public void applyProject(Project project) {
        this.applyProjectRequest(((ProjectRequestBuilder)((ProjectRequestBuilder)new ProjectRequestBuilder().withDisplayName(project.getMetadata().getName())).withMetadata(project.getMetadata())).build());
    }

    public void applyProjectRequest(ProjectRequest entity) {
        String projectName = KubernetesHelper.getOrCreateMetadata((HasMetadata)entity).getName();
        Objects.requireNonNull(projectName, "No name for " + entity);
        if (projectsCreated.contains(projectName)) {
            return;
        }
        this.log.info("Creating project: " + projectName, new Object[0]);
        if (!OpenshiftHelper.isOpenShift((KubernetesClient)this.kubernetesClient)) {
            this.log.warn("Cannot check for Project " + projectName + " as not running against OpenShift!", new Object[0]);
            return;
        }
        boolean exists = this.checkNamespace(projectName);
        if (!exists) {
            try {
                Object answer = this.asOpenShiftClient().projectrequests().create((Object)entity);
                projectsCreated.add(projectName);
                this.logGeneratedEntity("Created ProjectRequest: ", projectName, (HasMetadata)entity, answer);
            }
            catch (Exception e) {
                this.onApplyError("Failed to create ProjectRequest: " + projectName + " due " + e.getMessage(), e);
            }
        }
    }

    private void doCreate(HasMetadata resource, String namespace, String fileName) {
        String kind = KubernetesHelper.getKind((KubernetesResource)resource);
        try {
            Object answer;
            if (resource instanceof Namespaced) {
                this.log.info("Creating a %s in %s namespace with name %s from %s", new Object[]{kind, namespace, KubernetesHelper.getName((HasMetadata)resource), fileName});
                answer = this.kubernetesClient.resource(resource).inNamespace(namespace).create();
            } else {
                this.log.info("Creating a %s with name %s from %s", new Object[]{kind, KubernetesHelper.getName((HasMetadata)resource), fileName});
                answer = this.kubernetesClient.resource(resource).create();
            }
            this.logGeneratedEntity("Created " + kind + ": ", namespace, resource, answer);
        }
        catch (Exception e) {
            this.onApplyError("Failed to create " + kind + " from " + fileName + ". " + e + ". " + resource, e);
        }
    }

    public void applyReplicationController(ReplicationController replicationController, String sourceName) {
        block15: {
            String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)replicationController, this.namespace, this.fallbackNamespace);
            String id = KubernetesHelper.getName((HasMetadata)replicationController);
            Objects.requireNonNull(id, "No name for " + replicationController + " " + sourceName);
            if (this.isServicesOnlyMode()) {
                this.log.debug("Only processing Services right now so ignoring ReplicationController: " + currentNamespace + ":" + id, new Object[0]);
                return;
            }
            ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).get();
            if (this.isRunning((HasMetadata)old)) {
                if (UserConfigurationCompare.configEqual((Object)replicationController, (Object)old)) {
                    this.log.info("ReplicationController has not changed so not doing anything", new Object[0]);
                } else {
                    ReplicationControllerSpec newSpec = replicationController.getSpec();
                    ReplicationControllerSpec oldSpec = old.getSpec();
                    if (this.rollingUpgrade) {
                        Integer replicas;
                        this.log.info("Rolling upgrade of the ReplicationController: " + currentNamespace + "/" + id, new Object[0]);
                        if (this.rollingUpgradePreserveScale && newSpec != null && oldSpec != null && (replicas = oldSpec.getReplicas()) != null) {
                            newSpec.setReplicas(replicas);
                        }
                        this.log.info("rollingUpgradePreserveScale " + this.rollingUpgradePreserveScale + " new replicas is " + (newSpec != null ? newSpec.getReplicas() : "<null>"), new Object[0]);
                        ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).patch(PatchContext.of((PatchType)PatchType.SERVER_SIDE_APPLY), (Object)replicationController);
                    } else if (this.isRecreateMode()) {
                        this.log.info("Deleting ReplicationController: " + id, new Object[0]);
                        ((RollableScalableResource)((NonNamespaceOperation)this.kubernetesClient.replicationControllers().inNamespace(currentNamespace)).withName(id)).delete();
                        this.doCreate((HasMetadata)replicationController, currentNamespace, sourceName);
                    } else {
                        this.log.info("Updating ReplicationController from " + sourceName + " namespace " + currentNamespace + " name " + KubernetesHelper.getName((HasMetadata)replicationController), new Object[0]);
                        try {
                            ReplicationController answer = this.patchService.compareAndPatchEntity(currentNamespace, replicationController, old);
                            this.logGeneratedEntity("Updated replicationController: ", currentNamespace, (HasMetadata)replicationController, answer);
                            if (this.deletePodsOnReplicationControllerUpdate) {
                                ((FilterWatchListDeletable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(currentNamespace)).withLabels(newSpec.getSelector())).delete();
                                this.log.info("Deleting any pods for the replication controller to ensure they use the new configuration", new Object[0]);
                                break block15;
                            }
                            this.log.info("Warning not deleted any pods so they could well be running with the old configuration!", new Object[0]);
                        }
                        catch (Exception e) {
                            this.onApplyError("Failed to update ReplicationController from " + sourceName + ". " + e + ". " + replicationController, e);
                        }
                    }
                }
            } else if (!this.isAllowCreate()) {
                this.log.warn("Creation disabled so not creating a %s from %s in namespace %s with name %s", new Object[]{"ReplicationController", sourceName, currentNamespace, id});
            } else {
                this.doCreate((HasMetadata)replicationController, currentNamespace, sourceName);
            }
        }
    }

    protected void applyJob(Job job, String sourceName) {
        String currentNamespace = KubernetesClientUtil.applicableNamespace((HasMetadata)job, this.namespace, this.fallbackNamespace);
        String id = KubernetesHelper.getName((HasMetadata)job);
        Objects.requireNonNull(id, "No name for " + job + " " + sourceName);
        if (this.isServicesOnlyMode()) {
            this.log.debug("Only processing Services right now so ignoring Job: " + currentNamespace + ":" + id, new Object[0]);
            return;
        }
        try {
            this.log.info("Creating a Job from " + sourceName + " namespace " + this.namespace + " name " + KubernetesHelper.getName((HasMetadata)job), new Object[0]);
            ((ScalableResource)((NonNamespaceOperation)this.kubernetesClient.batch().v1().jobs().inNamespace(this.namespace)).resource((Object)job)).create();
        }
        catch (KubernetesClientException exception) {
            if (exception.getStatus().getCode().equals(409)) {
                Job old = (Job)((ScalableResource)((NonNamespaceOperation)this.kubernetesClient.batch().v1().jobs().inNamespace(currentNamespace)).withName(id)).get();
                Job updatedJob = this.patchService.compareAndPatchEntity(currentNamespace, job, old);
                this.log.info("Updated Job: " + updatedJob.getMetadata().getName(), new Object[0]);
                return;
            }
            this.onApplyError("Failed to apply Job from " + job.getMetadata().getName(), (Exception)((Object)exception));
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFallbackNamespace() {
        return this.fallbackNamespace;
    }

    protected String getNamespace(HasMetadata entity) {
        String answer = KubernetesHelper.getNamespace((HasMetadata)entity);
        if (StringUtils.isBlank((CharSequence)answer)) {
            answer = this.getNamespace();
        }
        this.applyNamespace(answer);
        return answer;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFallbackNamespace(String namespace) {
        this.fallbackNamespace = namespace;
    }

    public boolean isProcessTemplatesLocally() {
        return this.processTemplatesLocally;
    }

    public void setProcessTemplatesLocally(boolean processTemplatesLocally) {
        this.processTemplatesLocally = processTemplatesLocally;
    }

    public void setDeletePodsOnReplicationControllerUpdate(boolean deletePodsOnReplicationControllerUpdate) {
        this.deletePodsOnReplicationControllerUpdate = deletePodsOnReplicationControllerUpdate;
    }

    public void setLogJsonDir(File logJsonDir) {
        this.logJsonDir = logJsonDir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    protected boolean isRunning(HasMetadata entity) {
        return entity != null;
    }

    protected void onApplyError(String message, Exception e) {
        this.log.error(message, new Object[]{e});
        throw new RuntimeException(message, e);
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isRecreateMode() {
        return this.recreateMode;
    }

    public void setRecreateMode(boolean recreateMode) {
        this.recreateMode = recreateMode;
    }

    public void setServicesOnlyMode(boolean servicesOnlyMode) {
        this.servicesOnlyMode = servicesOnlyMode;
    }

    public boolean isServicesOnlyMode() {
        return this.servicesOnlyMode;
    }

    public boolean isIgnoreServiceMode() {
        return this.ignoreServiceMode;
    }

    public void setIgnoreServiceMode(boolean ignoreServiceMode) {
        this.ignoreServiceMode = ignoreServiceMode;
    }

    public boolean isIgnoreRunningOAuthClients() {
        return this.ignoreRunningOAuthClients;
    }

    public void setIgnoreRunningOAuthClients(boolean ignoreRunningOAuthClients) {
        this.ignoreRunningOAuthClients = ignoreRunningOAuthClients;
    }

    public boolean isIgnoreBoundPersistentVolumeClaims() {
        return this.ignoreBoundPersistentVolumeClaims;
    }

    public void setIgnoreBoundPersistentVolumeClaims(boolean ignoreBoundPersistentVolumeClaims) {
        this.ignoreBoundPersistentVolumeClaims = ignoreBoundPersistentVolumeClaims;
    }

    public void setSupportOAuthClients(boolean supportOAuthClients) {
        this.supportOAuthClients = supportOAuthClients;
    }

    public void setRollingUpgrade(boolean rollingUpgrade) {
        this.rollingUpgrade = rollingUpgrade;
    }

    public void setRollingUpgradePreserveScale(boolean rollingUpgradePreserveScale) {
        this.rollingUpgradePreserveScale = rollingUpgradePreserveScale;
    }

    public void applyEntities(String fileName, Collection<HasMetadata> entities) {
        ApplyService.getK8sListWithNamespaceFirst(entities).forEach(entity -> this.applyEntity(entity, fileName));
    }

    public static List<HasMetadata> getK8sListWithNamespaceFirst(Collection<HasMetadata> k8sList) {
        return k8sList.stream().sorted((Comparator<HasMetadata>)new HasMetadataComparator()).sorted((k1, k2) -> {
            if (ApplyService.isNamespaceOrProject(k1)) {
                return -1;
            }
            if (ApplyService.isNamespaceOrProject(k2)) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    private static boolean isNamespaceOrProject(HasMetadata h) {
        return h instanceof Namespace || h instanceof Project;
    }
}

