/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.io.File;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.helper.Task;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.BuildRecreateMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;

public class BuildServiceConfig {
    private BuildRecreateMode buildRecreateMode;
    private JKubeBuildStrategy jKubeBuildStrategy;
    private boolean forcePull;
    private String s2iBuildNameSuffix;
    private String openshiftPullSecret;
    private String openshiftPushSecret;
    private Task<KubernetesListBuilder> enricherTask;
    private String buildDirectory;
    private Attacher attacher;
    private ImagePullManager imagePullManager;
    private boolean s2iImageStreamLookupPolicyLocal;
    private ResourceConfig resourceConfig;
    private File resourceDir;
    private String buildOutputKind;

    public void attachArtifact(String classifier, File destFile) {
        if (this.attacher != null) {
            this.attacher.attach(classifier, destFile);
        }
    }

    public static BuildServiceConfigBuilder builder() {
        return new BuildServiceConfigBuilder();
    }

    public BuildServiceConfigBuilder toBuilder() {
        return new BuildServiceConfigBuilder().buildRecreateMode(this.buildRecreateMode).jKubeBuildStrategy(this.jKubeBuildStrategy).forcePull(this.forcePull).s2iBuildNameSuffix(this.s2iBuildNameSuffix).openshiftPullSecret(this.openshiftPullSecret).openshiftPushSecret(this.openshiftPushSecret).enricherTask(this.enricherTask).buildDirectory(this.buildDirectory).attacher(this.attacher).imagePullManager(this.imagePullManager).s2iImageStreamLookupPolicyLocal(this.s2iImageStreamLookupPolicyLocal).resourceConfig(this.resourceConfig).resourceDir(this.resourceDir).buildOutputKind(this.buildOutputKind);
    }

    public BuildServiceConfig(BuildRecreateMode buildRecreateMode, JKubeBuildStrategy jKubeBuildStrategy, boolean forcePull, String s2iBuildNameSuffix, String openshiftPullSecret, String openshiftPushSecret, Task<KubernetesListBuilder> enricherTask, String buildDirectory, Attacher attacher, ImagePullManager imagePullManager, boolean s2iImageStreamLookupPolicyLocal, ResourceConfig resourceConfig, File resourceDir, String buildOutputKind) {
        this.buildRecreateMode = buildRecreateMode;
        this.jKubeBuildStrategy = jKubeBuildStrategy;
        this.forcePull = forcePull;
        this.s2iBuildNameSuffix = s2iBuildNameSuffix;
        this.openshiftPullSecret = openshiftPullSecret;
        this.openshiftPushSecret = openshiftPushSecret;
        this.enricherTask = enricherTask;
        this.buildDirectory = buildDirectory;
        this.attacher = attacher;
        this.imagePullManager = imagePullManager;
        this.s2iImageStreamLookupPolicyLocal = s2iImageStreamLookupPolicyLocal;
        this.resourceConfig = resourceConfig;
        this.resourceDir = resourceDir;
        this.buildOutputKind = buildOutputKind;
    }

    public BuildServiceConfig() {
    }

    public BuildRecreateMode getBuildRecreateMode() {
        return this.buildRecreateMode;
    }

    public JKubeBuildStrategy getJKubeBuildStrategy() {
        return this.jKubeBuildStrategy;
    }

    public boolean isForcePull() {
        return this.forcePull;
    }

    public String getS2iBuildNameSuffix() {
        return this.s2iBuildNameSuffix;
    }

    public String getOpenshiftPullSecret() {
        return this.openshiftPullSecret;
    }

    public String getOpenshiftPushSecret() {
        return this.openshiftPushSecret;
    }

    public Task<KubernetesListBuilder> getEnricherTask() {
        return this.enricherTask;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public Attacher getAttacher() {
        return this.attacher;
    }

    public ImagePullManager getImagePullManager() {
        return this.imagePullManager;
    }

    public boolean isS2iImageStreamLookupPolicyLocal() {
        return this.s2iImageStreamLookupPolicyLocal;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public File getResourceDir() {
        return this.resourceDir;
    }

    public String getBuildOutputKind() {
        return this.buildOutputKind;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildServiceConfig)) {
            return false;
        }
        BuildServiceConfig other = (BuildServiceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForcePull() != other.isForcePull()) {
            return false;
        }
        if (this.isS2iImageStreamLookupPolicyLocal() != other.isS2iImageStreamLookupPolicyLocal()) {
            return false;
        }
        BuildRecreateMode this$buildRecreateMode = this.getBuildRecreateMode();
        BuildRecreateMode other$buildRecreateMode = other.getBuildRecreateMode();
        if (this$buildRecreateMode == null ? other$buildRecreateMode != null : !this$buildRecreateMode.equals(other$buildRecreateMode)) {
            return false;
        }
        JKubeBuildStrategy this$jKubeBuildStrategy = this.getJKubeBuildStrategy();
        JKubeBuildStrategy other$jKubeBuildStrategy = other.getJKubeBuildStrategy();
        if (this$jKubeBuildStrategy == null ? other$jKubeBuildStrategy != null : !this$jKubeBuildStrategy.equals(other$jKubeBuildStrategy)) {
            return false;
        }
        String this$s2iBuildNameSuffix = this.getS2iBuildNameSuffix();
        String other$s2iBuildNameSuffix = other.getS2iBuildNameSuffix();
        if (this$s2iBuildNameSuffix == null ? other$s2iBuildNameSuffix != null : !this$s2iBuildNameSuffix.equals(other$s2iBuildNameSuffix)) {
            return false;
        }
        String this$openshiftPullSecret = this.getOpenshiftPullSecret();
        String other$openshiftPullSecret = other.getOpenshiftPullSecret();
        if (this$openshiftPullSecret == null ? other$openshiftPullSecret != null : !this$openshiftPullSecret.equals(other$openshiftPullSecret)) {
            return false;
        }
        String this$openshiftPushSecret = this.getOpenshiftPushSecret();
        String other$openshiftPushSecret = other.getOpenshiftPushSecret();
        if (this$openshiftPushSecret == null ? other$openshiftPushSecret != null : !this$openshiftPushSecret.equals(other$openshiftPushSecret)) {
            return false;
        }
        Task<KubernetesListBuilder> this$enricherTask = this.getEnricherTask();
        Task<KubernetesListBuilder> other$enricherTask = other.getEnricherTask();
        if (this$enricherTask == null ? other$enricherTask != null : !this$enricherTask.equals(other$enricherTask)) {
            return false;
        }
        String this$buildDirectory = this.getBuildDirectory();
        String other$buildDirectory = other.getBuildDirectory();
        if (this$buildDirectory == null ? other$buildDirectory != null : !this$buildDirectory.equals(other$buildDirectory)) {
            return false;
        }
        Attacher this$attacher = this.getAttacher();
        Attacher other$attacher = other.getAttacher();
        if (this$attacher == null ? other$attacher != null : !this$attacher.equals(other$attacher)) {
            return false;
        }
        ImagePullManager this$imagePullManager = this.getImagePullManager();
        ImagePullManager other$imagePullManager = other.getImagePullManager();
        if (this$imagePullManager == null ? other$imagePullManager != null : !this$imagePullManager.equals(other$imagePullManager)) {
            return false;
        }
        ResourceConfig this$resourceConfig = this.getResourceConfig();
        ResourceConfig other$resourceConfig = other.getResourceConfig();
        if (this$resourceConfig == null ? other$resourceConfig != null : !this$resourceConfig.equals(other$resourceConfig)) {
            return false;
        }
        File this$resourceDir = this.getResourceDir();
        File other$resourceDir = other.getResourceDir();
        if (this$resourceDir == null ? other$resourceDir != null : !((Object)this$resourceDir).equals(other$resourceDir)) {
            return false;
        }
        String this$buildOutputKind = this.getBuildOutputKind();
        String other$buildOutputKind = other.getBuildOutputKind();
        return !(this$buildOutputKind == null ? other$buildOutputKind != null : !this$buildOutputKind.equals(other$buildOutputKind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildServiceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForcePull() ? 79 : 97);
        result = result * 59 + (this.isS2iImageStreamLookupPolicyLocal() ? 79 : 97);
        BuildRecreateMode $buildRecreateMode = this.getBuildRecreateMode();
        result = result * 59 + ($buildRecreateMode == null ? 43 : $buildRecreateMode.hashCode());
        JKubeBuildStrategy $jKubeBuildStrategy = this.getJKubeBuildStrategy();
        result = result * 59 + ($jKubeBuildStrategy == null ? 43 : $jKubeBuildStrategy.hashCode());
        String $s2iBuildNameSuffix = this.getS2iBuildNameSuffix();
        result = result * 59 + ($s2iBuildNameSuffix == null ? 43 : $s2iBuildNameSuffix.hashCode());
        String $openshiftPullSecret = this.getOpenshiftPullSecret();
        result = result * 59 + ($openshiftPullSecret == null ? 43 : $openshiftPullSecret.hashCode());
        String $openshiftPushSecret = this.getOpenshiftPushSecret();
        result = result * 59 + ($openshiftPushSecret == null ? 43 : $openshiftPushSecret.hashCode());
        Task<KubernetesListBuilder> $enricherTask = this.getEnricherTask();
        result = result * 59 + ($enricherTask == null ? 43 : $enricherTask.hashCode());
        String $buildDirectory = this.getBuildDirectory();
        result = result * 59 + ($buildDirectory == null ? 43 : $buildDirectory.hashCode());
        Attacher $attacher = this.getAttacher();
        result = result * 59 + ($attacher == null ? 43 : $attacher.hashCode());
        ImagePullManager $imagePullManager = this.getImagePullManager();
        result = result * 59 + ($imagePullManager == null ? 43 : $imagePullManager.hashCode());
        ResourceConfig $resourceConfig = this.getResourceConfig();
        result = result * 59 + ($resourceConfig == null ? 43 : $resourceConfig.hashCode());
        File $resourceDir = this.getResourceDir();
        result = result * 59 + ($resourceDir == null ? 43 : ((Object)$resourceDir).hashCode());
        String $buildOutputKind = this.getBuildOutputKind();
        result = result * 59 + ($buildOutputKind == null ? 43 : $buildOutputKind.hashCode());
        return result;
    }

    public static class BuildServiceConfigBuilder {
        private BuildRecreateMode buildRecreateMode;
        private JKubeBuildStrategy jKubeBuildStrategy;
        private boolean forcePull;
        private String s2iBuildNameSuffix;
        private String openshiftPullSecret;
        private String openshiftPushSecret;
        private Task<KubernetesListBuilder> enricherTask;
        private String buildDirectory;
        private Attacher attacher;
        private ImagePullManager imagePullManager;
        private boolean s2iImageStreamLookupPolicyLocal;
        private ResourceConfig resourceConfig;
        private File resourceDir;
        private String buildOutputKind;

        BuildServiceConfigBuilder() {
        }

        public BuildServiceConfigBuilder buildRecreateMode(BuildRecreateMode buildRecreateMode) {
            this.buildRecreateMode = buildRecreateMode;
            return this;
        }

        public BuildServiceConfigBuilder jKubeBuildStrategy(JKubeBuildStrategy jKubeBuildStrategy) {
            this.jKubeBuildStrategy = jKubeBuildStrategy;
            return this;
        }

        public BuildServiceConfigBuilder forcePull(boolean forcePull) {
            this.forcePull = forcePull;
            return this;
        }

        public BuildServiceConfigBuilder s2iBuildNameSuffix(String s2iBuildNameSuffix) {
            this.s2iBuildNameSuffix = s2iBuildNameSuffix;
            return this;
        }

        public BuildServiceConfigBuilder openshiftPullSecret(String openshiftPullSecret) {
            this.openshiftPullSecret = openshiftPullSecret;
            return this;
        }

        public BuildServiceConfigBuilder openshiftPushSecret(String openshiftPushSecret) {
            this.openshiftPushSecret = openshiftPushSecret;
            return this;
        }

        public BuildServiceConfigBuilder enricherTask(Task<KubernetesListBuilder> enricherTask) {
            this.enricherTask = enricherTask;
            return this;
        }

        public BuildServiceConfigBuilder buildDirectory(String buildDirectory) {
            this.buildDirectory = buildDirectory;
            return this;
        }

        public BuildServiceConfigBuilder attacher(Attacher attacher) {
            this.attacher = attacher;
            return this;
        }

        public BuildServiceConfigBuilder imagePullManager(ImagePullManager imagePullManager) {
            this.imagePullManager = imagePullManager;
            return this;
        }

        public BuildServiceConfigBuilder s2iImageStreamLookupPolicyLocal(boolean s2iImageStreamLookupPolicyLocal) {
            this.s2iImageStreamLookupPolicyLocal = s2iImageStreamLookupPolicyLocal;
            return this;
        }

        public BuildServiceConfigBuilder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public BuildServiceConfigBuilder resourceDir(File resourceDir) {
            this.resourceDir = resourceDir;
            return this;
        }

        public BuildServiceConfigBuilder buildOutputKind(String buildOutputKind) {
            this.buildOutputKind = buildOutputKind;
            return this;
        }

        public BuildServiceConfig build() {
            return new BuildServiceConfig(this.buildRecreateMode, this.jKubeBuildStrategy, this.forcePull, this.s2iBuildNameSuffix, this.openshiftPullSecret, this.openshiftPushSecret, this.enricherTask, this.buildDirectory, this.attacher, this.imagePullManager, this.s2iImageStreamLookupPolicyLocal, this.resourceConfig, this.resourceDir, this.buildOutputKind);
        }

        public String toString() {
            return "BuildServiceConfig.BuildServiceConfigBuilder(buildRecreateMode=" + this.buildRecreateMode + ", jKubeBuildStrategy=" + this.jKubeBuildStrategy + ", forcePull=" + this.forcePull + ", s2iBuildNameSuffix=" + this.s2iBuildNameSuffix + ", openshiftPullSecret=" + this.openshiftPullSecret + ", openshiftPushSecret=" + this.openshiftPushSecret + ", enricherTask=" + this.enricherTask + ", buildDirectory=" + this.buildDirectory + ", attacher=" + this.attacher + ", imagePullManager=" + this.imagePullManager + ", s2iImageStreamLookupPolicyLocal=" + this.s2iImageStreamLookupPolicyLocal + ", resourceConfig=" + this.resourceConfig + ", resourceDir=" + this.resourceDir + ", buildOutputKind=" + this.buildOutputKind + ")";
        }
    }

    public static interface Attacher {
        public void attach(String var1, File var2);
    }
}

