/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service.ingresscontroller;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.networking.v1.IngressClassList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.eclipse.jkube.kit.common.IngressControllerDetector;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;

public class NginxIngressControllerDetector
implements IngressControllerDetector {
    private final KubernetesClient client;
    private static final String INGRESS_NGINX_NAMESPACE = "ingress-nginx";

    public NginxIngressControllerDetector(KubernetesClient client) {
        this.client = client;
    }

    public boolean hasIngressClass() {
        return !((IngressClassList)((FilterWatchListDeletable)this.client.network().v1().ingressClasses().withLabel("app.kubernetes.io/name", INGRESS_NGINX_NAMESPACE)).list()).getItems().isEmpty();
    }

    public boolean isIngressControllerReady() {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(INGRESS_NGINX_NAMESPACE)).withLabel("app.kubernetes.io/name", INGRESS_NGINX_NAMESPACE)).list()).getItems().stream().anyMatch(KubernetesHelper::isPodReady);
    }

    public boolean hasPermissions() {
        return KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, null, (String)"networking.k8s.io", (String)"ingressclasses", (String)"list") && KubernetesHelper.hasAccessForAction((KubernetesClient)this.client, (String)INGRESS_NGINX_NAMESPACE, null, (String)"pods", (String)"list");
    }
}

