/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.util.Optional;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class GeneratorContext {
    private JavaProject project;
    private ProcessorConfig config;
    private KitLogger logger;
    private RuntimeMode runtimeMode;
    private JKubeBuildStrategy strategy;
    private boolean useProjectClasspath;
    private boolean prePackagePhase;
    private GeneratorMode generatorMode;

    public GeneratorMode getGeneratorMode() {
        return Optional.ofNullable(this.generatorMode).orElse(GeneratorMode.BUILD);
    }

    public static GeneratorContextBuilder builder() {
        return new GeneratorContextBuilder();
    }

    public GeneratorContextBuilder toBuilder() {
        return new GeneratorContextBuilder().project(this.project).config(this.config).logger(this.logger).runtimeMode(this.runtimeMode).strategy(this.strategy).useProjectClasspath(this.useProjectClasspath).prePackagePhase(this.prePackagePhase).generatorMode(this.generatorMode);
    }

    private GeneratorContext() {
    }

    public GeneratorContext(JavaProject project, ProcessorConfig config, KitLogger logger, RuntimeMode runtimeMode, JKubeBuildStrategy strategy, boolean useProjectClasspath, boolean prePackagePhase, GeneratorMode generatorMode) {
        this.project = project;
        this.config = config;
        this.logger = logger;
        this.runtimeMode = runtimeMode;
        this.strategy = strategy;
        this.useProjectClasspath = useProjectClasspath;
        this.prePackagePhase = prePackagePhase;
        this.generatorMode = generatorMode;
    }

    public JavaProject getProject() {
        return this.project;
    }

    public ProcessorConfig getConfig() {
        return this.config;
    }

    public KitLogger getLogger() {
        return this.logger;
    }

    public RuntimeMode getRuntimeMode() {
        return this.runtimeMode;
    }

    public JKubeBuildStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isUseProjectClasspath() {
        return this.useProjectClasspath;
    }

    public boolean isPrePackagePhase() {
        return this.prePackagePhase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneratorContext)) {
            return false;
        }
        GeneratorContext other = (GeneratorContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseProjectClasspath() != other.isUseProjectClasspath()) {
            return false;
        }
        if (this.isPrePackagePhase() != other.isPrePackagePhase()) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        ProcessorConfig this$config = this.getConfig();
        ProcessorConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        KitLogger this$logger = this.getLogger();
        KitLogger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        RuntimeMode this$runtimeMode = this.getRuntimeMode();
        RuntimeMode other$runtimeMode = other.getRuntimeMode();
        if (this$runtimeMode == null ? other$runtimeMode != null : !this$runtimeMode.equals(other$runtimeMode)) {
            return false;
        }
        JKubeBuildStrategy this$strategy = this.getStrategy();
        JKubeBuildStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        GeneratorMode this$generatorMode = this.getGeneratorMode();
        GeneratorMode other$generatorMode = other.getGeneratorMode();
        return !(this$generatorMode == null ? other$generatorMode != null : !((Object)((Object)this$generatorMode)).equals((Object)other$generatorMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneratorContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseProjectClasspath() ? 79 : 97);
        result = result * 59 + (this.isPrePackagePhase() ? 79 : 97);
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        ProcessorConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        KitLogger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        RuntimeMode $runtimeMode = this.getRuntimeMode();
        result = result * 59 + ($runtimeMode == null ? 43 : $runtimeMode.hashCode());
        JKubeBuildStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        GeneratorMode $generatorMode = this.getGeneratorMode();
        result = result * 59 + ($generatorMode == null ? 43 : ((Object)((Object)$generatorMode)).hashCode());
        return result;
    }

    public static class GeneratorContextBuilder {
        private JavaProject project;
        private ProcessorConfig config;
        private KitLogger logger;
        private RuntimeMode runtimeMode;
        private JKubeBuildStrategy strategy;
        private boolean useProjectClasspath;
        private boolean prePackagePhase;
        private GeneratorMode generatorMode;

        GeneratorContextBuilder() {
        }

        public GeneratorContextBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        public GeneratorContextBuilder config(ProcessorConfig config) {
            this.config = config;
            return this;
        }

        public GeneratorContextBuilder logger(KitLogger logger) {
            this.logger = logger;
            return this;
        }

        public GeneratorContextBuilder runtimeMode(RuntimeMode runtimeMode) {
            this.runtimeMode = runtimeMode;
            return this;
        }

        public GeneratorContextBuilder strategy(JKubeBuildStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public GeneratorContextBuilder useProjectClasspath(boolean useProjectClasspath) {
            this.useProjectClasspath = useProjectClasspath;
            return this;
        }

        public GeneratorContextBuilder prePackagePhase(boolean prePackagePhase) {
            this.prePackagePhase = prePackagePhase;
            return this;
        }

        public GeneratorContextBuilder generatorMode(GeneratorMode generatorMode) {
            this.generatorMode = generatorMode;
            return this;
        }

        public GeneratorContext build() {
            return new GeneratorContext(this.project, this.config, this.logger, this.runtimeMode, this.strategy, this.useProjectClasspath, this.prePackagePhase, this.generatorMode);
        }

        public String toString() {
            return "GeneratorContext.GeneratorContextBuilder(project=" + this.project + ", config=" + this.config + ", logger=" + this.logger + ", runtimeMode=" + this.runtimeMode + ", strategy=" + this.strategy + ", useProjectClasspath=" + this.useProjectClasspath + ", prePackagePhase=" + this.prePackagePhase + ", generatorMode=" + (Object)((Object)this.generatorMode) + ")";
        }
    }
}

