/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.api;

import java.util.List;
import org.eclipse.jkube.generator.api.Generator;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.ClassUtil;
import org.eclipse.jkube.kit.common.util.PluginServiceFactory;
import org.eclipse.jkube.kit.config.image.GeneratorManager;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class DefaultGeneratorManager
implements GeneratorManager {
    private static final String[] SERVICE_PATHS = new String[]{"META-INF/jkube/generator-default", "META-INF/jkube/jkube-generator-default", "META-INF/jkube/generator", "META-INF/jkube-generator"};
    private final GeneratorContext genCtx;

    public DefaultGeneratorManager(GeneratorContext context) {
        this.genCtx = context;
    }

    public List<ImageConfiguration> generate(List<ImageConfiguration> imageConfigs) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)this.genCtx, new ClassLoader[0]);
        if (this.genCtx.isUseProjectClasspath()) {
            pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((List)this.genCtx.getProject().getCompileClassPathElements(), (KitLogger)this.genCtx.getLogger()));
        }
        List<ImageConfiguration> ret = imageConfigs;
        KitLogger log = this.genCtx.getLogger();
        List generators = pluginFactory.createServiceObjects(SERVICE_PATHS);
        List usableGenerators = this.genCtx.getConfig().prepareProcessors(generators, "generator");
        log.verbose("Generators:", new Object[0]);
        for (Generator generator : usableGenerators) {
            log.verbose(" - %s", new Object[]{generator.getName()});
            if (!generator.isApplicable(ret)) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret, this.genCtx.isPrePackagePhase());
        }
        return ret;
    }
}

