/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.generator.webapp.AppServerDetector;
import org.eclipse.jkube.generator.webapp.AppServerHandler;
import org.eclipse.jkube.generator.webapp.handler.CustomAppServerHandler;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.JKubeBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class WebAppGenerator
extends BaseGenerator {
    public WebAppGenerator(GeneratorContext context) {
        super(context, "webapp");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddGeneratedImageConfiguration(configs) && (JKubeProjectUtil.hasPlugin((JavaProject)this.getProject(), (String)"org.apache.maven.plugins", (String)"maven-war-plugin") || JKubeProjectUtil.hasGradlePlugin((JavaProject)this.getProject(), (String)"org.gradle.api.plugins.WarPlugin"));
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        AppServerHandler handler = this.getAppServerHandler(this.getContext());
        if (this.getContext().getRuntimeMode() == RuntimeMode.OPENSHIFT && this.getContext().getStrategy() == JKubeBuildStrategy.s2i && !prePackagePhase && !handler.supportsS2iBuild()) {
            throw new IllegalArgumentException("S2I not yet supported for the webapp-generator. Use -Djkube.build.strategy=docker for OpenShift mode. Please refer to the reference manual at https://www.eclipse.dev/jkube/docs for details about build modes.");
        }
        this.log.info("Using %s as base image for webapp", new Object[]{handler.getFrom()});
        ImageConfiguration.ImageConfigurationBuilder imageBuilder = ImageConfiguration.builder();
        BuildConfiguration.BuildConfigurationBuilder buildBuilder = BuildConfiguration.builder();
        buildBuilder.from(this.getFrom(handler)).ports(handler.exposedPorts()).env(this.getEnv(handler));
        String dockerRunCommand = this.getDockerRunCommand(handler);
        if (dockerRunCommand != null) {
            buildBuilder.cmd(Arguments.builder().shell(dockerRunCommand).build());
        }
        handler.runCmds().forEach(arg_0 -> ((BuildConfiguration.BuildConfigurationBuilder)buildBuilder).runCmd(arg_0));
        this.addSchemaLabels(buildBuilder, this.log);
        if (!prePackagePhase) {
            buildBuilder.assembly(this.createAssembly(handler));
        }
        this.addLatestTagIfSnapshot(buildBuilder);
        this.addTagsFromConfig(buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).build(buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    private AppServerHandler getAppServerHandler(GeneratorContext context) {
        String from = super.getFromAsConfigured();
        if (from != null) {
            return this.createCustomAppServerHandler(from);
        }
        return new AppServerDetector(context).detect(this.getConfig(Config.SERVER));
    }

    private AppServerHandler createCustomAppServerHandler(String from) {
        String deploymentDir = this.getConfig(Config.TARGET_DIR);
        String command = this.getConfig(Config.CMD);
        String user = this.getConfig(Config.USER);
        List<String> ports = Arrays.asList(this.getConfig(Config.PORTS).split("\\s*,\\s*"));
        boolean supportsS2iBuild = Configs.asBoolean((String)this.getConfig(Config.SUPPORTS_S2I_BUILD));
        return new CustomAppServerHandler(from, deploymentDir, command, user, ports, supportsS2iBuild);
    }

    protected Map<String, String> getEnv(AppServerHandler handler) {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        defaultEnv.put("DEPLOY_DIR", this.getDeploymentDir(handler));
        defaultEnv.putAll(handler.getEnv());
        defaultEnv.putAll(WebAppGenerator.extractEnvVariables(this.getConfig(Config.ENV)));
        if ("webapps-javaee".equals(defaultEnv.get("TOMCAT_WEBAPPS_DIR"))) {
            this.log.info("[[B]]HINT:[[B]] Tomcat webapps dir is set to `webapps-javaee` by default for retrocompatibility. If your project is already JakartaEE compliant, set `jkube.generator.webapp.env` to `TOMCAT_WEBAPPS_DIR=webapps` for a faster startup.", new Object[0]);
        }
        return defaultEnv;
    }

    public static Map<String, String> extractEnvVariables(String envConfigValue) {
        if (StringUtils.isBlank((CharSequence)envConfigValue)) {
            return Collections.emptyMap();
        }
        return Pattern.compile("\\n\\s*").splitAsStream(envConfigValue).map(envNameValue -> envNameValue.split("=")).filter(e -> ((String[])e).length == 2).collect(Collectors.toMap(e -> e[0], e -> e[1]));
    }

    private AssemblyConfiguration createAssembly(AppServerHandler handler) {
        File sourceFile = Objects.requireNonNull(JKubeProjectUtil.getFinalOutputArtifact((JavaProject)this.getProject()), "Final output artifact file was not detected. The project may have not been built. HINT: try to compile and package your application prior to running the container image build task.");
        String extension = FilenameUtils.getExtension((String)sourceFile.getName());
        String path = this.getConfig(Config.PATH);
        String targetFilename = path.equals("/") || StringUtils.isBlank((CharSequence)path) ? String.format("ROOT.%s", extension) : String.format("%s.%s", path.replaceAll("[\\\\/]", ""), extension);
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = AssemblyConfiguration.builder();
        builder.name(handler.getAssemblyName()).targetDir(this.getDeploymentDir(handler)).excludeFinalOutputArtifact(true).inline(Assembly.builder().file(AssemblyFile.builder().source(sourceFile).destName(targetFilename).outputDirectory(new File(".")).build()).build());
        String user = this.getUser(handler);
        if (user != null) {
            builder.user(user);
        }
        return builder.build();
    }

    protected String getFrom(AppServerHandler handler) {
        return handler.getFrom();
    }

    private String getDockerRunCommand(AppServerHandler handler) {
        return this.getConfig(Config.CMD, handler.getCommand());
    }

    private String getDeploymentDir(AppServerHandler handler) {
        return this.getConfig(Config.TARGET_DIR, handler.getDeploymentDir());
    }

    private String getUser(AppServerHandler handler) {
        return this.getConfig(Config.USER, handler.getUser());
    }

    private static enum Config implements Configs.Config
    {
        SERVER("server", null),
        TARGET_DIR("targetDir", "/deployments"),
        USER("user", null),
        CMD("cmd", null),
        PATH("path", "/"),
        PORTS("ports", "8080"),
        SUPPORTS_S2I_BUILD("supportsS2iBuild", "false"),
        ENV("env", null);

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

