/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;

public class HelmRepositoryConnectionUtils {
    private HelmRepositoryConnectionUtils() {
    }

    protected static HttpURLConnection getConnectionForUploadToChartMuseum(File file, HelmRepository repository) throws IOException {
        return HelmRepositoryConnectionUtils.createConnection(repository, repository.getUrl());
    }

    protected static HttpURLConnection getConnectionForUploadToArtifactory(File file, HelmRepository repository) throws IOException {
        HttpURLConnection connection = HelmRepositoryConnectionUtils.createConnection(repository, HelmRepositoryConnectionUtils.formatRepositoryURL(file, repository));
        connection.setRequestMethod("PUT");
        return connection;
    }

    protected static HttpURLConnection getConnectionForUploadToNexus(File file, HelmRepository repository) throws IOException {
        String url = HelmRepositoryConnectionUtils.formatRepositoryURL(file, repository);
        if (url.endsWith(".tar.gz")) {
            url = url.replaceAll("tar.gz$", "tgz");
        }
        HttpURLConnection connection = HelmRepositoryConnectionUtils.createConnection(repository, url);
        connection.setRequestMethod("PUT");
        return connection;
    }

    private static HttpURLConnection createConnection(HelmRepository repository, String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/gzip");
        HelmRepositoryConnectionUtils.verifyAndSetAuthentication(repository);
        return connection;
    }

    private static String formatRepositoryURL(File file, HelmRepository repository) {
        return String.format("%s%s", StringUtils.appendIfMissing((String)repository.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]), file.getName());
    }

    private static void verifyAndSetAuthentication(HelmRepository helmRepository) {
        if (StringUtils.isNotBlank((CharSequence)helmRepository.getUsername()) && StringUtils.isNotBlank((CharSequence)helmRepository.getPassword())) {
            final PasswordAuthentication authentication = new PasswordAuthentication(helmRepository.getUsername(), helmRepository.getPassword().toCharArray());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return authentication;
                }
            });
        }
    }
}

