/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.quarkus.generator.AbstractQuarkusNestedGenerator;

public class FastJarGenerator
extends AbstractQuarkusNestedGenerator {
    public FastJarGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig) {
        super(generatorContext, generatorConfig);
    }

    @Override
    public AssemblyConfiguration createAssemblyConfiguration() {
        JavaProject project = this.getProject();
        File quarkusAppDirectory = new File(project.getBuildDirectory(), "quarkus-app");
        if (!quarkusAppDirectory.exists()) {
            throw new IllegalStateException("The quarkus-app directory required in Quarkus Fast Jar mode was not found. HINT: try to compile and package your application prior to running the container image build task.");
        }
        AssemblyFileSet.AssemblyFileSetBuilder libFileSet = this.createFileSet().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)quarkusAppDirectory)).include("lib").fileMode("0640");
        AssemblyFileSet.AssemblyFileSetBuilder fastJarFileSet = this.createFileSet().directory(FileUtil.getRelativePath((File)project.getBaseDirectory(), (File)quarkusAppDirectory)).include("quarkus-run.jar").include("*").include("**/*").exclude("lib/**/*").exclude("lib/*").fileMode("0640");
        return AssemblyConfiguration.builder().targetDir(this.getTargetDir()).excludeFinalOutputArtifact(true).layer(Assembly.builder().id("lib").fileSet(libFileSet.build()).build()).layer(Assembly.builder().id("fast-jar").fileSet(fastJarFileSet.build()).build()).build();
    }
}

