/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.generator;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;
import org.eclipse.jkube.quarkus.QuarkusUtils;
import org.eclipse.jkube.quarkus.generator.FastJarGenerator;
import org.eclipse.jkube.quarkus.generator.LegacyJarGenerator;
import org.eclipse.jkube.quarkus.generator.NativeGenerator;
import org.eclipse.jkube.quarkus.generator.QuarkusGenerator;
import org.eclipse.jkube.quarkus.generator.UberJarGenerator;

public interface QuarkusNestedGenerator {
    public JavaProject getProject();

    public RuntimeMode getRuntimeMode();

    public AssemblyConfiguration createAssemblyConfiguration();

    default public boolean isFatJar() {
        return false;
    }

    default public String getFrom() {
        return null;
    }

    default public String getDefaultJolokiaPort() {
        return "8778";
    }

    default public String getDefaultPrometheusPort() {
        return "9779";
    }

    default public Arguments getBuildEntryPoint() {
        return null;
    }

    public String getBuildWorkdir();

    public String getTargetDir();

    public static QuarkusNestedGenerator from(GeneratorContext context, GeneratorConfig config) {
        if (Boolean.parseBoolean(config.get((Configs.Config)QuarkusGenerator.Config.NATIVE_IMAGE))) {
            return new NativeGenerator(context, config);
        }
        Properties quarkusConfiguration = QuarkusUtils.getQuarkusConfiguration(context.getProject());
        return (QuarkusNestedGenerator)QuarkusNestedGenerator.from(quarkusConfiguration).orElseGet(() -> QuarkusNestedGenerator.fromFiles(context.getProject(), quarkusConfiguration)).apply(context, config);
    }

    public static Optional<BiFunction<GeneratorContext, GeneratorConfig, ? extends QuarkusNestedGenerator>> from(Properties properties) {
        String packageType = properties.getProperty("quarkus.package.type");
        if (packageType == null) {
            return Optional.empty();
        }
        switch (packageType) {
            case "native": {
                return Optional.of(NativeGenerator::new);
            }
            case "fast-jar": {
                return Optional.of(FastJarGenerator::new);
            }
            case "legacy-jar": {
                return Optional.of(LegacyJarGenerator::new);
            }
            case "uber-jar": {
                return Optional.of(UberJarGenerator::new);
            }
        }
        return Optional.empty();
    }

    public static BiFunction<GeneratorContext, GeneratorConfig, ? extends QuarkusNestedGenerator> fromFiles(JavaProject project, Properties properties) {
        String runnerSuffix = QuarkusUtils.runnerSuffix(properties);
        if (QuarkusNestedGenerator.hasFileThatEndsWith(project, runnerSuffix + ".jar") && new File(project.getBuildDirectory(), "lib").exists()) {
            return LegacyJarGenerator::new;
        }
        if (QuarkusNestedGenerator.hasFileThatEndsWith(project, runnerSuffix + ".jar")) {
            return UberJarGenerator::new;
        }
        if (QuarkusNestedGenerator.hasFileThatEndsWith(project, runnerSuffix)) {
            return NativeGenerator::new;
        }
        return FastJarGenerator::new;
    }

    public static boolean hasFileThatEndsWith(JavaProject project, String suffix) {
        File buildDir = project.getBuildDirectory();
        String[] file = buildDir.list((dir, name) -> name.endsWith(suffix));
        return file != null && file.length > 0;
    }
}

