/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.remotedev;

public class RemoteService {
    private String hostname;
    private int port;
    private Integer localPort;

    public int getLocalPort() {
        return this.localPort == null ? this.port : this.localPort;
    }

    public static RemoteServiceBuilder builder() {
        return new RemoteServiceBuilder();
    }

    public RemoteServiceBuilder toBuilder() {
        return new RemoteServiceBuilder().hostname(this.hostname).port(this.port).localPort(this.localPort);
    }

    public RemoteService(String hostname, int port, Integer localPort) {
        this.hostname = hostname;
        this.port = port;
        this.localPort = localPort;
    }

    public RemoteService() {
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteService)) {
            return false;
        }
        RemoteService other = (RemoteService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getLocalPort() != other.getLocalPort()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getLocalPort();
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    public static class RemoteServiceBuilder {
        private String hostname;
        private int port;
        private Integer localPort;

        RemoteServiceBuilder() {
        }

        public RemoteServiceBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public RemoteServiceBuilder port(int port) {
            this.port = port;
            return this;
        }

        public RemoteServiceBuilder localPort(Integer localPort) {
            this.localPort = localPort;
            return this;
        }

        public RemoteService build() {
            return new RemoteService(this.hostname, this.port, this.localPort);
        }

        public String toString() {
            return "RemoteService.RemoteServiceBuilder(hostname=" + this.hostname + ", port=" + this.port + ", localPort=" + this.localPort + ")";
        }
    }
}

