/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm.oci;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.resource.helm.Chart;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.oci.OCIManifestLayer;

public class OCIRegistryEndpoint {
    private static final Map<String, String> PROTOCOL_MAPPER = new HashMap<String, String>();
    private final URI baseUrl;
    private final URI apiV2Url;

    public OCIRegistryEndpoint(HelmRepository repository) {
        URI repositoryUri = URI.create(StringUtils.removeEnd((String)repository.getUrl(), (String)"/"));
        this.baseUrl = URI.create(PROTOCOL_MAPPER.getOrDefault(repositoryUri.getScheme(), repositoryUri.getScheme()) + "://" + repositoryUri.getHost() + (repositoryUri.getPort() > 0 ? ":" + repositoryUri.getPort() : ""));
        this.apiV2Url = URI.create(this.baseUrl + "/v2" + repositoryUri.getPath());
    }

    public String getBlobUrl(Chart chart, OCIManifestLayer blob) {
        return String.format("%s/%s/blobs/%s", this.apiV2Url, chart.getName(), blob.getDigest());
    }

    public String getBlobUploadInitUrl(Chart chart) {
        return String.format("%s/%s/blobs/uploads/", this.apiV2Url, chart.getName());
    }

    public String getManifestUrl(Chart chart) {
        return String.format("%s/%s/manifests/%s", this.apiV2Url, chart.getName(), chart.getVersion());
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    static {
        PROTOCOL_MAPPER.put("oci", "http");
        PROTOCOL_MAPPER.put("ocis", "https");
    }
}

