/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.service;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceFragments;
import org.eclipse.jkube.kit.resource.service.TemplateUtil;

class WriteUtil {
    private static final HasMetadataComparator COMPARATOR = new HasMetadataComparator();

    private WriteUtil() {
    }

    static File writeResourcesIndividualAndComposite(KubernetesList resources, File resourceFileBase, ResourceFileType resourceFileType, KitLogger log) throws IOException {
        resources.getItems().sort(COMPARATOR);
        KubernetesList entity = resources;
        Template template = TemplateUtil.getSingletonTemplate(resources);
        if (template != null) {
            template.getObjects().sort(COMPARATOR);
            entity = template;
        }
        File file = WriteUtil.writeResource(resourceFileBase, (KubernetesResource)entity, resourceFileType);
        WriteUtil.writeIndividualResources(resources, resourceFileBase, resourceFileType, log);
        return file;
    }

    private static void writeIndividualResources(KubernetesList resources, File targetDir, ResourceFileType resourceFileType, KitLogger log) throws IOException {
        HashMap<String, Integer> generatedFiles = new HashMap<String, Integer>();
        for (HasMetadata item : resources.getItems()) {
            String name = KubernetesHelper.getName((HasMetadata)item);
            if (StringUtils.isBlank((CharSequence)name)) {
                log.error("No name for generated item %s", new Object[]{item});
                continue;
            }
            String fileName = KubernetesResourceFragments.getNameWithSuffix((String)name, (String)item.getKind());
            int fileCount = generatedFiles.compute(fileName, (f, i) -> i == null ? 0 : i + 1);
            if (fileCount > 0) {
                fileName = KubernetesResourceFragments.getNameWithSuffix((String)(name + "-" + fileCount), (String)item.getKind());
            }
            File itemTarget = new File(targetDir, fileName);
            WriteUtil.writeResource(itemTarget, (KubernetesResource)item, resourceFileType);
        }
    }

    static File writeResource(File resourceFileBase, KubernetesResource entity, ResourceFileType resourceFileType) throws IOException {
        try {
            return ResourceUtil.save((File)resourceFileBase, (Object)entity, (ResourceFileType)resourceFileType);
        }
        catch (IOException e) {
            throw new IOException("Failed to write resource to " + resourceFileBase + ".", e);
        }
    }
}

