/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.jkube.generator.javaexec.FatJarDetector;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;

public class SpringBootDevtoolsUtils {
    private SpringBootDevtoolsUtils() {
    }

    public static boolean ensureSpringDevToolSecretToken(JavaProject project) {
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)project), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)project));
        String remoteSecret = properties.getProperty("spring.devtools.remote.secret");
        if (Strings.isNullOrEmpty((String)remoteSecret)) {
            SpringBootDevtoolsUtils.addSecretTokenToApplicationProperties(project);
            return false;
        }
        return true;
    }

    private static void addSecretTokenToApplicationProperties(JavaProject project) {
        String newToken = UUID.randomUUID().toString();
        SpringBootDevtoolsUtils.appendSecretTokenToFile(project, "target/classes/application.properties", newToken);
        SpringBootDevtoolsUtils.appendSecretTokenToFile(project, "src/main/resources/application.properties", newToken);
    }

    private static void appendSecretTokenToFile(JavaProject project, String path, String token) {
        File file = new File(project.getBaseDirectory(), path);
        boolean dirCreated = file.getParentFile().mkdirs();
        if (!dirCreated) {
            throw new IllegalStateException("Failure in creating directory " + file.getParentFile().getAbsolutePath());
        }
        String text = String.format("%s# Remote secret added by jkube-kit-plugin\n%s=%s\n", file.exists() ? "\n" : "", "spring.devtools.remote.secret", token);
        try (FileWriter writer = new FileWriter(file, true);){
            writer.append(text);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to append to file: " + file + ". " + e, e);
        }
    }

    public static void addDevToolsFilesToFatJar(JavaProject project, FatJarDetector.Result fatJarDetectResult) {
        File target = SpringBootDevtoolsUtils.getFatJarFile(fatJarDetectResult);
        try {
            File devToolsFile = SpringBootDevtoolsUtils.getSpringBootDevToolsJar(project);
            File applicationPropertiesFile = new File(project.getBaseDirectory(), "target/classes/application.properties");
            SpringBootDevtoolsUtils.copyFilesToFatJar(Collections.singletonList(devToolsFile), Collections.singletonList(applicationPropertiesFile), target);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to add devtools files to fat jar " + target + ". " + e, e);
        }
    }

    private static void copyFilesToFatJar(List<File> libs, List<File> classes, File target) throws IOException {
        File tmpZip = File.createTempFile(target.getName(), null);
        Files.delete(tmpZip.toPath());
        FileUtils.moveFile((File)target, (File)tmpZip);
        byte[] buffer = new byte[8192];
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tmpZip));
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(target));){
            Throwable throwable;
            FileInputStream in;
            ZipEntry ze = zin.getNextEntry();
            while (ze != null) {
                if (!SpringBootDevtoolsUtils.matchesFatJarEntry(libs, ze.getName(), true) && !SpringBootDevtoolsUtils.matchesFatJarEntry(classes, ze.getName(), false)) {
                    out.putNextEntry(ze);
                    int read = zin.read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = zin.read(buffer);
                    }
                    out.closeEntry();
                }
                ze = zin.getNextEntry();
            }
            for (File lib : libs) {
                in = new FileInputStream(lib);
                throwable = null;
                try {
                    out.putNextEntry(SpringBootDevtoolsUtils.createZipEntry(lib, SpringBootDevtoolsUtils.getFatJarFullPath(lib, true)));
                    int read = ((InputStream)in).read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = ((InputStream)in).read(buffer);
                    }
                    out.closeEntry();
                }
                catch (Throwable read) {
                    throwable = read;
                    throw read;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable read) {
                            throwable.addSuppressed(read);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
            for (File cls : classes) {
                in = new FileInputStream(cls);
                throwable = null;
                try {
                    out.putNextEntry(SpringBootDevtoolsUtils.createZipEntry(cls, SpringBootDevtoolsUtils.getFatJarFullPath(cls, false)));
                    int read = ((InputStream)in).read(buffer);
                    while (read > -1) {
                        out.write(buffer, 0, read);
                        read = ((InputStream)in).read(buffer);
                    }
                    out.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
        }
        Files.delete(tmpZip.toPath());
    }

    private static boolean matchesFatJarEntry(List<File> fatJarEntries, String path, boolean lib) {
        for (File e : fatJarEntries) {
            String fullPath = SpringBootDevtoolsUtils.getFatJarFullPath(e, lib);
            if (!fullPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static String getFatJarFullPath(File file, boolean lib) {
        if (lib) {
            return "BOOT-INF/lib/" + file.getName();
        }
        return "BOOT-INF/classes/" + file.getName();
    }

    private static ZipEntry createZipEntry(File file, String fullPath) throws IOException {
        ZipEntry entry = new ZipEntry(fullPath);
        byte[] buffer = new byte[8192];
        int bytesRead = -1;
        try (FileInputStream is = new FileInputStream(file);){
            CRC32 crc = new CRC32();
            int size = 0;
            while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                crc.update(buffer, 0, bytesRead);
                size += bytesRead;
            }
            entry.setSize(size);
            entry.setCompressedSize(size);
            entry.setCrc(crc.getValue());
            entry.setMethod(0);
            ZipEntry zipEntry = entry;
            return zipEntry;
        }
    }

    private static File getFatJarFile(FatJarDetector.Result fatJarDetectResult) {
        if (fatJarDetectResult == null) {
            throw new IllegalStateException("No fat jar built yet. Please ensure that the 'package' phase has run");
        }
        return fatJarDetectResult.getArchiveFile();
    }

    private static File getSpringBootDevToolsJar(JavaProject project) {
        String version = (String)SpringBootUtil.getSpringBootDevToolsVersion((JavaProject)project).orElseThrow(() -> new IllegalStateException("Unable to find the spring-boot version"));
        File devToolsJar = JKubeProjectUtil.resolveArtifact((JavaProject)project, (String)"org.springframework.boot", (String)"spring-boot-devtools", (String)version, (String)"jar");
        if (!devToolsJar.exists()) {
            throw new IllegalArgumentException("devtools need to be included in repacked archive, please set <excludeDevtools> to false in plugin configuration");
        }
        return devToolsJar;
    }
}

