/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;

public class SpringBootLayeredJar {
    private final File layeredJar;
    private final KitLogger kitLogger;

    public SpringBootLayeredJar(File layeredJar, KitLogger kitLogger) {
        this.layeredJar = layeredJar;
        this.kitLogger = kitLogger;
    }

    public List<String> listLayers() {
        LayerListCommand layerListCommand = new LayerListCommand(this.kitLogger, this.layeredJar);
        try {
            layerListCommand.execute();
            return layerListCommand.getLayers();
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failure in getting spring boot jar layers information", ioException);
        }
    }

    public void extractLayers(File extractionDir) {
        try {
            new LayerExtractorCommand(this.kitLogger, extractionDir, this.layeredJar).execute();
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failure in extracting spring boot jar layers", ioException);
        }
    }

    private static class LayerListCommand
    extends ExternalCommand {
        private final File layeredJar;
        private final List<String> layers;

        protected LayerListCommand(KitLogger log, File layeredJar) {
            super(log);
            this.layeredJar = layeredJar;
            this.layers = new ArrayList<String>();
        }

        protected String[] getArgs() {
            return new String[]{"java", "-Djarmode=layertools", "-jar", this.layeredJar.getAbsolutePath(), "list"};
        }

        protected void processLine(String line) {
            this.layers.add(line);
        }

        public List<String> getLayers() {
            return this.layers;
        }
    }

    private static class LayerExtractorCommand
    extends ExternalCommand {
        private final File layeredJar;

        protected LayerExtractorCommand(KitLogger log, File workDir, File layeredJar) {
            super(log, workDir);
            this.layeredJar = layeredJar;
        }

        protected String[] getArgs() {
            return new String[]{"java", "-Djarmode=layertools", "-jar", this.layeredJar.getAbsolutePath(), "extract"};
        }
    }
}

