/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.springboot.generator;

import java.net.URLClassLoader;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jkube.generator.api.GeneratorConfig;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.GeneratorMode;
import org.eclipse.jkube.generator.javaexec.JavaExecGenerator;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;
import org.eclipse.jkube.springboot.generator.SpringBootNestedGenerator;

public abstract class AbstractSpringBootNestedGenerator
implements SpringBootNestedGenerator {
    private final GeneratorContext generatorContext;
    private final GeneratorConfig generatorConfig;

    AbstractSpringBootNestedGenerator(GeneratorContext generatorContext, GeneratorConfig generatorConfig) {
        this.generatorContext = generatorContext;
        this.generatorConfig = generatorConfig;
    }

    @Override
    public final JavaProject getProject() {
        return this.generatorContext.getProject();
    }

    @Override
    public String getBuildWorkdir() {
        return this.generatorConfig.get((Configs.Config)JavaExecGenerator.Config.TARGET_DIR);
    }

    @Override
    public String getTargetDir() {
        return this.generatorConfig.get((Configs.Config)JavaExecGenerator.Config.TARGET_DIR);
    }

    @Override
    public Map<String, String> getEnv(Function<Boolean, Map<String, String>> javaExecEnvSupplier, boolean prePackagePhase) {
        String secret;
        Map<String, String> res = javaExecEnvSupplier.apply(prePackagePhase);
        if (this.generatorContext.getGeneratorMode() == GeneratorMode.WATCH && (secret = SpringBootUtil.getSpringBootApplicationProperties((String)SpringBootUtil.getSpringBootActiveProfile((JavaProject)this.getProject()), (URLClassLoader)JKubeProjectUtil.getClassLoader((JavaProject)this.getProject())).getProperty("spring.devtools.remote.secret")) != null) {
            res.put("SPRING_DEVTOOLS_REMOTE_SECRET", secret);
        }
        return res;
    }

    protected KitLogger getLogger() {
        return this.generatorContext.getLogger();
    }
}

