/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.develop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.jkube.kit.common.util.ResourceUtil;
import org.eclipse.jkube.maven.plugin.mojo.ManifestProvider;
import org.eclipse.jkube.maven.plugin.mojo.build.AbstractJKubeMojo;

@Mojo(name="undeploy", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class UndeployMojo
extends AbstractJKubeMojo
implements ManifestProvider {
    @Parameter(property="jkube.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/jkube/kubernetes.yml")
    protected File kubernetesManifest;
    @Parameter(property="jkube.skip.undeploy", defaultValue="false")
    protected boolean skipUndeploy;

    @Override
    public File getKubernetesManifest() {
        return this.kubernetesManifest;
    }

    @Override
    public final void executeInternal() throws MojoExecutionException {
        try {
            this.undeploy();
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    protected void undeploy() throws IOException {
        List environmentResourceDirs = ResourceUtil.getFinalResourceDirs((File)this.resourceDir, (String)this.environment);
        this.jkubeServiceHub.getUndeployService().undeploy(environmentResourceDirs, this.resources, this.getManifestsToUndeploy().toArray(new File[0]));
    }

    protected List<File> getManifestsToUndeploy() {
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(this.getManifest(this.jkubeServiceHub.getClient()));
        return ret;
    }

    @Override
    protected boolean shouldSkip() {
        return super.shouldSkip() || this.skipUndeploy;
    }
}

