/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.common;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.client.ml.dataframe.evaluation.common.AucRocPoint;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AucRocResult
implements EvaluationMetric.Result {
    public static final String NAME = "auc_roc";
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField CURVE = new ParseField("curve", new String[0]);
    private static final ConstructingObjectParser<AucRocResult, Void> PARSER = new ConstructingObjectParser("auc_roc", true, args -> new AucRocResult((Double)args[0], (List)args[1]));
    private final double value;
    private final List<AucRocPoint> curve;

    public static AucRocResult fromXContent(XContentParser parser) {
        return (AucRocResult)PARSER.apply(parser, null);
    }

    public AucRocResult(double value, @Nullable List<AucRocPoint> curve) {
        this.value = value;
        this.curve = curve;
    }

    @Override
    public String getMetricName() {
        return NAME;
    }

    public double getValue() {
        return this.value;
    }

    public List<AucRocPoint> getCurve() {
        return this.curve == null ? null : Collections.unmodifiableList(this.curve);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VALUE.getPreferredName(), this.value);
        if (this.curve != null && !this.curve.isEmpty()) {
            builder.field(CURVE.getPreferredName(), this.curve);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRocResult that = (AucRocResult)o;
        return this.value == that.value && Objects.equals(this.curve, that.curve);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.curve);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), VALUE);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> AucRocPoint.fromXContent(p), CURVE);
    }
}

