/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.indexlifecycle.LifecycleAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class WaitForSnapshotAction
implements LifecycleAction,
ToXContentObject {
    public static final String NAME = "wait_for_snapshot";
    public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
    private static final ConstructingObjectParser<WaitForSnapshotAction, Void> PARSER = new ConstructingObjectParser("wait_for_snapshot", true, a -> new WaitForSnapshotAction((String)a[0]));
    private final String policy;

    public static WaitForSnapshotAction parse(XContentParser parser) {
        return (WaitForSnapshotAction)PARSER.apply(parser, null);
    }

    public WaitForSnapshotAction(String policy) {
        if (!Strings.hasText((String)policy)) {
            throw new IllegalArgumentException("policy name must be specified");
        }
        this.policy = policy;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_FIELD.getPreferredName(), this.policy);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitForSnapshotAction that = (WaitForSnapshotAction)o;
        return this.policy.equals(that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.policy);
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_FIELD);
    }
}

