/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe.transforms;

import java.util.Objects;
import org.elasticsearch.client.dataframe.transforms.DataFrameTransformCheckpointStats;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformCheckpointingInfo {
    public static final ParseField CURRENT_CHECKPOINT = new ParseField("current", new String[0]);
    public static final ParseField IN_PROGRESS_CHECKPOINT = new ParseField("in_progress", new String[0]);
    public static final ParseField OPERATIONS_BEHIND = new ParseField("operations_behind", new String[0]);
    private final DataFrameTransformCheckpointStats current;
    private final DataFrameTransformCheckpointStats inProgress;
    private final long operationsBehind;
    private static final ConstructingObjectParser<DataFrameTransformCheckpointingInfo, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpointing_info", true, a -> {
        long behind = a[2] == null ? 0L : (Long)a[2];
        return new DataFrameTransformCheckpointingInfo(a[0] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[0], a[1] == null ? DataFrameTransformCheckpointStats.EMPTY : (DataFrameTransformCheckpointStats)a[1], behind);
    });

    public DataFrameTransformCheckpointingInfo(DataFrameTransformCheckpointStats current, DataFrameTransformCheckpointStats inProgress, long operationsBehind) {
        this.current = Objects.requireNonNull(current);
        this.inProgress = Objects.requireNonNull(inProgress);
        this.operationsBehind = operationsBehind;
    }

    public DataFrameTransformCheckpointStats getCurrent() {
        return this.current;
    }

    public DataFrameTransformCheckpointStats getInProgress() {
        return this.inProgress;
    }

    public long getOperationsBehind() {
        return this.operationsBehind;
    }

    public static DataFrameTransformCheckpointingInfo fromXContent(XContentParser p) {
        return (DataFrameTransformCheckpointingInfo)LENIENT_PARSER.apply(p, null);
    }

    public int hashCode() {
        return Objects.hash(this.current, this.inProgress, this.operationsBehind);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointingInfo that = (DataFrameTransformCheckpointingInfo)other;
        return Objects.equals(this.current, that.current) && Objects.equals(this.inProgress, that.inProgress) && this.operationsBehind == that.operationsBehind;
    }

    static {
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformCheckpointStats.fromXContent(p), CURRENT_CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformCheckpointStats.fromXContent(p), IN_PROGRESS_CHECKPOINT);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), OPERATIONS_BEHIND);
    }
}

