/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.ServiceTaskXMLConverter;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.child.InParameterParser;
import org.flowable.bpmn.converter.child.OutParameterParser;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CaseServiceTask;

public class CaseServiceTaskXMLConverter
extends ServiceTaskXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public CaseServiceTaskXMLConverter() {
        InParameterParser inParameterParser = new InParameterParser();
        this.childParserMap.put(inParameterParser.getElementName(), inParameterParser);
        OutParameterParser outParameterParser = new OutParameterParser();
        this.childParserMap.put(outParameterParser.getElementName(), outParameterParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return CaseServiceTask.class;
    }

    @Override
    protected void convertCaseServiceTaskXMLProperties(CaseServiceTask caseServiceTask, BpmnModel bpmnModel, XMLStreamReader xtr) throws Exception {
        String caseInstanceName;
        String caseDefinitionKey = BpmnXMLUtil.getAttributeValue("caseDefinitionKey", xtr);
        if (StringUtils.isNotEmpty((CharSequence)caseDefinitionKey)) {
            caseServiceTask.setCaseDefinitionKey(caseDefinitionKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)(caseInstanceName = BpmnXMLUtil.getAttributeValue("caseInstanceName", xtr)))) {
            caseServiceTask.setCaseInstanceName(caseInstanceName);
        }
        caseServiceTask.setBusinessKey(BpmnXMLUtil.getAttributeValue("businessKey", xtr));
        caseServiceTask.setInheritBusinessKey(Boolean.parseBoolean(BpmnXMLUtil.getAttributeValue("inheritBusinessKey", xtr)));
        caseServiceTask.setSameDeployment(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("sameDeployment", xtr)).booleanValue());
        caseServiceTask.setFallbackToDefaultTenant(Boolean.valueOf(BpmnXMLUtil.getAttributeValue("fallbackToDefaultTenant", xtr)).booleanValue());
        this.parseChildElements(this.getXMLElementName(), (BaseElement)caseServiceTask, this.childParserMap, bpmnModel, xtr);
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        CaseServiceTask caseServiceTask = (CaseServiceTask)element;
        this.writeQualifiedAttribute("type", "case", xtw);
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", caseServiceTask.getSkipExpression(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseDefinitionKey())) {
            this.writeQualifiedAttribute("caseDefinitionKey", caseServiceTask.getCaseDefinitionKey(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceName())) {
            this.writeQualifiedAttribute("caseInstanceName", caseServiceTask.getCaseInstanceName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getBusinessKey())) {
            this.writeQualifiedAttribute("businessKey", caseServiceTask.getBusinessKey(), xtw);
        }
        if (caseServiceTask.isInheritBusinessKey()) {
            this.writeQualifiedAttribute("inheritBusinessKey", "true", xtw);
        }
        if (caseServiceTask.isSameDeployment()) {
            this.writeQualifiedAttribute("sameDeployment", "true", xtw);
        }
        if (caseServiceTask.isFallbackToDefaultTenant()) {
            this.writeQualifiedAttribute("fallbackToDefaultTenant", "true", xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        CaseServiceTask caseServiceTask = (CaseServiceTask)element;
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("in", caseServiceTask.getInParameters(), didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeIOParameters("out", caseServiceTask.getOutParameters(), didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

