/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.export;

import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.export.FieldExtensionExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;

public class FlowableListenerExport
implements BpmnXMLConstants {
    public static boolean writeListeners(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (element instanceof HasExecutionListeners) {
            didWriteExtensionStartElement = FlowableListenerExport.writeListeners("executionListener", ((HasExecutionListeners)element).getExecutionListeners(), didWriteExtensionStartElement, xtw);
        }
        if (element instanceof UserTask) {
            didWriteExtensionStartElement = FlowableListenerExport.writeListeners("taskListener", ((UserTask)element).getTaskListeners(), didWriteExtensionStartElement, xtw);
        }
        if (element instanceof Process) {
            didWriteExtensionStartElement = FlowableListenerExport.writeEventListeners(((Process)element).getEventListeners(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    protected static boolean writeEventListeners(List<EventListener> eventListeners, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (eventListeners != null && !eventListeners.isEmpty()) {
            for (EventListener eventListener : eventListeners) {
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", "eventListener", "http://flowable.org/bpmn");
                BpmnXMLUtil.writeDefaultAttribute("events", eventListener.getEvents(), xtw);
                BpmnXMLUtil.writeDefaultAttribute("entityType", eventListener.getEntityType(), xtw);
                if (StringUtils.isNotEmpty((CharSequence)eventListener.getOnTransaction())) {
                    BpmnXMLUtil.writeDefaultAttribute("onTransaction", eventListener.getOnTransaction(), xtw);
                }
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("class", eventListener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("delegateExpression", eventListener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("signalName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "signal", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("signalName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "globalSignal", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("messageName", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "message", xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT.equals(eventListener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("errorCode", eventListener.getImplementation(), xtw);
                    BpmnXMLUtil.writeDefaultAttribute("throwEvent", "error", xtw);
                }
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }

    private static boolean writeListeners(String xmlElementName, List<FlowableListener> listenerList, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        if (listenerList != null) {
            for (FlowableListener listener : listenerList) {
                if (!StringUtils.isNotEmpty((CharSequence)listener.getEvent())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", xmlElementName, "http://flowable.org/bpmn");
                BpmnXMLUtil.writeDefaultAttribute("event", listener.getEvent(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("class", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("expression", listener.getImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("delegateExpression", listener.getImplementation(), xtw);
                }
                BpmnXMLUtil.writeDefaultAttribute("onTransaction", listener.getOnTransaction(), xtw);
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getCustomPropertiesResolverImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("customPropertiesResolverClass", listener.getCustomPropertiesResolverImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getCustomPropertiesResolverImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("customPropertiesResolverExpression", listener.getCustomPropertiesResolverImplementation(), xtw);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getCustomPropertiesResolverImplementationType())) {
                    BpmnXMLUtil.writeDefaultAttribute("customPropertiesResolverDelegateExpression", listener.getCustomPropertiesResolverImplementation(), xtw);
                }
                FieldExtensionExport.writeFieldExtensions(listener.getFieldExtensions(), true, xtw);
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }
}

