/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.child.BaseChildElementParser;
import org.flowable.bpmn.converter.export.FailedJobRetryCountExport;
import org.flowable.bpmn.converter.export.FlowableListenerExport;
import org.flowable.bpmn.converter.export.MultiInstanceExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Assignment;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.DataAssociation;
import org.flowable.bpmn.model.DataObject;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.FormProperty;
import org.flowable.bpmn.model.FormValue;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.TerminateEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.UserTask;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBpmnXMLConverter
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseBpmnXMLConverter.class);
    protected static final List<ExtensionAttribute> defaultElementAttributes = Arrays.asList(new ExtensionAttribute("id"), new ExtensionAttribute("name"));
    protected static final List<ExtensionAttribute> defaultActivityAttributes = Arrays.asList(new ExtensionAttribute("async"), new ExtensionAttribute("asyncBefore"), new ExtensionAttribute("exclusive"), new ExtensionAttribute("default"), new ExtensionAttribute("isForCompensation"));

    public void convertToBpmnModel(XMLStreamReader xtr, BpmnModel model, Process activeProcess, List<SubProcess> activeSubProcessList) throws Exception {
        String elementId = xtr.getAttributeValue(null, "id");
        String elementName = xtr.getAttributeValue(null, "name");
        boolean async = this.parseAsync(xtr);
        boolean asyncLeave = this.parsAsyncLeave(xtr);
        boolean triggerable = this.parseTriggerable(xtr);
        boolean notExclusive = this.parseNotExclusive(xtr);
        boolean asyncLeaveNotExclusive = this.parseAsyncLeaveNotExclusive(xtr);
        String defaultFlow = xtr.getAttributeValue(null, "default");
        boolean isForCompensation = this.parseForCompensation(xtr);
        BaseElement parsedElement = this.convertXMLToElement(xtr, model);
        if (parsedElement instanceof Artifact) {
            Artifact currentArtifact = (Artifact)parsedElement;
            currentArtifact.setId(elementId);
            if (!activeSubProcessList.isEmpty()) {
                activeSubProcessList.get(activeSubProcessList.size() - 1).addArtifact(currentArtifact);
            } else {
                activeProcess.addArtifact(currentArtifact);
            }
        }
        if (parsedElement instanceof FlowElement) {
            SubProcess subProcess;
            FlowElement currentFlowElement = (FlowElement)parsedElement;
            currentFlowElement.setId(elementId);
            currentFlowElement.setName(elementName);
            if (currentFlowElement instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)currentFlowElement;
                flowNode.setAsynchronous(async);
                flowNode.setAsynchronousLeave(asyncLeave);
                flowNode.setNotExclusive(notExclusive);
                flowNode.setAsynchronousLeaveNotExclusive(asyncLeaveNotExclusive);
                if (currentFlowElement instanceof Activity) {
                    Activity activity = (Activity)currentFlowElement;
                    activity.setForCompensation(isForCompensation);
                    if (StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                        activity.setDefaultFlow(defaultFlow);
                    }
                }
                if (currentFlowElement instanceof Gateway) {
                    Gateway gateway = (Gateway)currentFlowElement;
                    if (StringUtils.isNotEmpty((CharSequence)defaultFlow)) {
                        gateway.setDefaultFlow(defaultFlow);
                    }
                }
                if (currentFlowElement instanceof ServiceTask) {
                    ServiceTask serviceTask = (ServiceTask)currentFlowElement;
                    serviceTask.setTriggerable(triggerable);
                }
            }
            if (currentFlowElement instanceof DataObject) {
                if (!activeSubProcessList.isEmpty()) {
                    subProcess = activeSubProcessList.get(activeSubProcessList.size() - 1);
                    subProcess.getDataObjects().add((ValuedDataObject)parsedElement);
                } else {
                    activeProcess.getDataObjects().add((ValuedDataObject)parsedElement);
                }
            }
            if (!activeSubProcessList.isEmpty()) {
                subProcess = activeSubProcessList.get(activeSubProcessList.size() - 1);
                subProcess.addFlowElement(currentFlowElement);
            } else {
                activeProcess.addFlowElement(currentFlowElement);
            }
        }
    }

    public void convertToXML(XMLStreamWriter xtw, BaseElement baseElement, BpmnModel model) throws Exception {
        Activity activity;
        FlowElement flowElement;
        xtw.writeStartElement(this.getXMLElementName());
        boolean didWriteExtensionStartElement = false;
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        if (baseElement instanceof FlowElement) {
            this.writeDefaultAttribute("name", ((FlowElement)baseElement).getName(), xtw);
        }
        if (baseElement instanceof FlowNode) {
            Gateway gateway;
            FlowElement defaultFlowElement;
            FlowNode flowNode = (FlowNode)baseElement;
            if (flowNode.isAsynchronous()) {
                this.writeQualifiedAttribute("async", "true", xtw);
                if (flowNode.isNotExclusive()) {
                    this.writeQualifiedAttribute("exclusive", "false", xtw);
                }
            }
            if (flowNode.isAsynchronousLeave()) {
                this.writeQualifiedAttribute("asyncLeave", "true", xtw);
                if (flowNode.isAsynchronousLeaveNotExclusive()) {
                    this.writeQualifiedAttribute("asyncLeaveExclusive", "false", xtw);
                }
            }
            if (baseElement instanceof Activity) {
                Activity activity2 = (Activity)baseElement;
                if (activity2.isForCompensation()) {
                    this.writeDefaultAttribute("isForCompensation", "true", xtw);
                }
                if (StringUtils.isNotEmpty((CharSequence)activity2.getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(activity2.getDefaultFlow())) instanceof SequenceFlow) {
                    this.writeDefaultAttribute("default", activity2.getDefaultFlow(), xtw);
                }
            }
            if (baseElement instanceof Gateway && StringUtils.isNotEmpty((CharSequence)(gateway = (Gateway)baseElement).getDefaultFlow()) && (defaultFlowElement = model.getFlowElement(gateway.getDefaultFlow())) instanceof SequenceFlow) {
                this.writeDefaultAttribute("default", gateway.getDefaultFlow(), xtw);
            }
        }
        this.writeAdditionalAttributes(baseElement, model, xtw);
        if (baseElement instanceof FlowElement && StringUtils.isNotEmpty((CharSequence)(flowElement = (FlowElement)baseElement).getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(flowElement.getDocumentation());
            xtw.writeEndElement();
        }
        didWriteExtensionStartElement = this.writeExtensionChildElements(baseElement, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeListeners(baseElement, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements(baseElement, didWriteExtensionStartElement, model.getNamespaces(), xtw);
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            didWriteExtensionStartElement = FailedJobRetryCountExport.writeFailedJobRetryCount(activity, didWriteExtensionStartElement, xtw);
        }
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        if (baseElement instanceof Activity) {
            activity = (Activity)baseElement;
            MultiInstanceExport.writeMultiInstance(activity, model, xtw);
            for (DataAssociation dataInputAssociation : activity.getDataInputAssociations()) {
                this.writeDataAssociation("dataInputAssociation", dataInputAssociation, xtw);
            }
            for (DataAssociation dataOutputAssociation : activity.getDataOutputAssociations()) {
                this.writeDataAssociation("dataOutputAssociation", dataOutputAssociation, xtw);
            }
        }
        this.writeAdditionalChildElements(baseElement, model, xtw);
        xtw.writeEndElement();
    }

    protected abstract Class<? extends BaseElement> getBpmnElementType();

    protected abstract BaseElement convertXMLToElement(XMLStreamReader var1, BpmnModel var2) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(BaseElement var1, BpmnModel var2, XMLStreamWriter var3) throws Exception;

    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return didWriteExtensionStartElement;
    }

    protected abstract void writeAdditionalChildElements(BaseElement var1, BpmnModel var2, XMLStreamWriter var3) throws Exception;

    protected void parseChildElements(String elementName, BaseElement parentElement, BpmnModel model, XMLStreamReader xtr) throws Exception {
        this.parseChildElements(elementName, parentElement, null, model, xtr);
    }

    protected void parseChildElements(String elementName, BaseElement parentElement, Map<String, BaseChildElementParser> additionalParsers, BpmnModel model, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (additionalParsers != null) {
            childParsers.putAll(additionalParsers);
        }
        BpmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, model);
    }

    protected ExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        ExtensionElement extensionElement = new ExtensionElement();
        BpmnXMLUtil.addXMLLocation((BaseElement)extensionElement, xtr);
        extensionElement.setName(xtr.getLocalName());
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)extensionElement, defaultElementAttributes);
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters() || 12 == xtr.getEventType()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                extensionElement.setElementText(xtr.getText().trim());
                continue;
            }
            if (xtr.isStartElement()) {
                ExtensionElement childExtensionElement = this.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    protected boolean parseAsync(XMLStreamReader xtr) {
        boolean async = false;
        String asyncString = BpmnXMLUtil.getAttributeValue("async", xtr);
        if (asyncString == null) {
            asyncString = xtr.getAttributeValue("http://camunda.org/schema/1.0/bpmn", "asyncBefore");
        }
        if ("true".equalsIgnoreCase(asyncString)) {
            async = true;
        }
        return async;
    }

    protected boolean parseNotExclusive(XMLStreamReader xtr) {
        boolean notExclusive = false;
        String exclusiveString = BpmnXMLUtil.getAttributeValue("exclusive", xtr);
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        return notExclusive;
    }

    protected boolean parseAsyncLeaveNotExclusive(XMLStreamReader xtr) {
        boolean notExclusive = false;
        String exclusiveString = BpmnXMLUtil.getAttributeValue("asyncLeaveExclusive", xtr);
        if ("false".equalsIgnoreCase(exclusiveString)) {
            notExclusive = true;
        }
        return notExclusive;
    }

    protected boolean parsAsyncLeave(XMLStreamReader xtr) {
        String asyncLeaveString = BpmnXMLUtil.getAttributeValue("asyncLeave", xtr);
        if (StringUtils.isEmpty((CharSequence)asyncLeaveString)) {
            asyncLeaveString = BpmnXMLUtil.getAttributeValue("asyncAfter", xtr);
        }
        return "true".equalsIgnoreCase(asyncLeaveString);
    }

    protected boolean parseTriggerable(XMLStreamReader xtr) {
        String triggerable = BpmnXMLUtil.getAttributeValue("triggerable", xtr);
        return "true".equalsIgnoreCase(triggerable);
    }

    protected boolean parseForCompensation(XMLStreamReader xtr) {
        boolean isForCompensation = false;
        String compensationString = xtr.getAttributeValue(null, "isForCompensation");
        if ("true".equalsIgnoreCase(compensationString)) {
            isForCompensation = true;
        }
        return isForCompensation;
    }

    protected List<String> parseDelimitedList(String expression) {
        return BpmnXMLUtil.parseDelimitedList(expression);
    }

    protected String convertToDelimitedString(List<String> stringList) {
        return BpmnXMLUtil.convertToDelimitedString(stringList);
    }

    protected boolean writeFormProperties(FlowElement flowElement, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        List propertyList = null;
        if (flowElement instanceof UserTask) {
            propertyList = ((UserTask)flowElement).getFormProperties();
        } else if (flowElement instanceof StartEvent) {
            propertyList = ((StartEvent)flowElement).getFormProperties();
        }
        if (propertyList != null) {
            for (FormProperty property : propertyList) {
                if (!StringUtils.isNotEmpty((CharSequence)property.getId())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", "formProperty", "http://flowable.org/bpmn");
                this.writeDefaultAttribute("id", property.getId(), xtw);
                this.writeDefaultAttribute("name", property.getName(), xtw);
                this.writeDefaultAttribute("type", property.getType(), xtw);
                this.writeDefaultAttribute("expression", property.getExpression(), xtw);
                this.writeDefaultAttribute("variable", property.getVariable(), xtw);
                this.writeDefaultAttribute("default", property.getDefaultExpression(), xtw);
                this.writeDefaultAttribute("datePattern", property.getDatePattern(), xtw);
                if (!property.isReadable()) {
                    this.writeDefaultAttribute("readable", "false", xtw);
                }
                if (!property.isWriteable()) {
                    this.writeDefaultAttribute("writable", "false", xtw);
                }
                if (property.isRequired()) {
                    this.writeDefaultAttribute("required", "true", xtw);
                }
                for (FormValue formValue : property.getFormValues()) {
                    if (!StringUtils.isNotEmpty((CharSequence)formValue.getId())) continue;
                    xtw.writeStartElement("flowable", "value", "http://flowable.org/bpmn");
                    xtw.writeAttribute("id", formValue.getId());
                    xtw.writeAttribute("name", formValue.getName());
                    xtw.writeEndElement();
                }
                xtw.writeEndElement();
            }
        }
        return didWriteExtensionStartElement;
    }

    protected boolean writeListeners(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return FlowableListenerExport.writeListeners(element, didWriteExtensionStartElement, xtw);
    }

    protected void writeEventDefinitions(Event parentEvent, List<EventDefinition> eventDefinitions, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        for (EventDefinition eventDefinition : eventDefinitions) {
            if (eventDefinition instanceof TimerEventDefinition) {
                this.writeTimerDefinition(parentEvent, (TimerEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                this.writeSignalDefinition(parentEvent, (SignalEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                this.writeMessageDefinition(parentEvent, (MessageEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof ConditionalEventDefinition) {
                this.writeConditionalDefinition(parentEvent, (ConditionalEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                this.writeErrorDefinition(parentEvent, (ErrorEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof EscalationEventDefinition) {
                this.writeEscalationDefinition(parentEvent, (EscalationEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof TerminateEventDefinition) {
                this.writeTerminateDefinition(parentEvent, (TerminateEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (eventDefinition instanceof CancelEventDefinition) {
                this.writeCancelDefinition(parentEvent, (CancelEventDefinition)eventDefinition, model, xtw);
                continue;
            }
            if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
            this.writeCompensateDefinition(parentEvent, (CompensateEventDefinition)eventDefinition, model, xtw);
        }
    }

    protected void writeTimerDefinition(Event parentEvent, TimerEventDefinition timerDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("timerEventDefinition");
        if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getCalendarName())) {
            this.writeQualifiedAttribute("businessCalendarName", timerDefinition.getCalendarName(), xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)timerDefinition, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDate())) {
            xtw.writeStartElement("timeDate");
            xtw.writeCharacters(timerDefinition.getTimeDate());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeCycle())) {
            xtw.writeStartElement("timeCycle");
            if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getEndDate())) {
                xtw.writeAttribute("flowable", "http://flowable.org/bpmn", "endDate", timerDefinition.getEndDate());
            }
            xtw.writeCharacters(timerDefinition.getTimeCycle());
            xtw.writeEndElement();
        } else if (StringUtils.isNotEmpty((CharSequence)timerDefinition.getTimeDuration())) {
            xtw.writeStartElement("timeDuration");
            xtw.writeCharacters(timerDefinition.getTimeDuration());
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeSignalDefinition(Event parentEvent, SignalEventDefinition signalDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("signalEventDefinition");
        if (StringUtils.isNotEmpty((CharSequence)signalDefinition.getSignalRef())) {
            this.writeDefaultAttribute("signalRef", signalDefinition.getSignalRef(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)signalDefinition.getSignalExpression())) {
            xtw.writeAttribute("flowable", "http://flowable.org/bpmn", "signalExpression", signalDefinition.getSignalExpression());
        }
        if (parentEvent instanceof ThrowEvent && signalDefinition.isAsync()) {
            BpmnXMLUtil.writeQualifiedAttribute("async", "true", xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)signalDefinition, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeCancelDefinition(Event parentEvent, CancelEventDefinition cancelEventDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("cancelEventDefinition");
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)cancelEventDefinition, false, model.getNamespaces(), xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeCompensateDefinition(Event parentEvent, CompensateEventDefinition compensateEventDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("compensateEventDefinition");
        this.writeDefaultAttribute("activityRef", compensateEventDefinition.getActivityRef(), xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)compensateEventDefinition, false, model.getNamespaces(), xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeMessageDefinition(Event parentEvent, MessageEventDefinition messageDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("messageEventDefinition");
        Object messageRef = messageDefinition.getMessageRef();
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            if (((String)messageRef).startsWith(model.getTargetNamespace())) {
                messageRef = ((String)messageRef).replace(model.getTargetNamespace(), "");
                messageRef = ((String)messageRef).replaceFirst(":", "");
            } else {
                for (String prefix : model.getNamespaces().keySet()) {
                    String namespace = model.getNamespace(prefix);
                    if (!((String)messageRef).startsWith(namespace)) continue;
                    messageRef = ((String)messageRef).replace(model.getTargetNamespace(), "");
                    messageRef = prefix + (String)messageRef;
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)messageRef)) {
            this.writeDefaultAttribute("messageRef", (String)messageRef, xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)messageDefinition.getMessageExpression())) {
            xtw.writeAttribute("flowable", "http://flowable.org/bpmn", "messageExpression", messageDefinition.getMessageExpression());
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)messageDefinition, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeConditionalDefinition(Event parentEvent, ConditionalEventDefinition conditionalDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("conditionalEventDefinition");
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)conditionalDefinition, false, model.getNamespaces(), xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        if (StringUtils.isNotEmpty((CharSequence)conditionalDefinition.getConditionExpression())) {
            xtw.writeStartElement("condition");
            xtw.writeCharacters(conditionalDefinition.getConditionExpression());
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeErrorDefinition(Event parentEvent, ErrorEventDefinition errorDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("errorEventDefinition");
        this.writeDefaultAttribute("errorRef", errorDefinition.getErrorCode(), xtw);
        this.writeQualifiedAttribute("errorVariableName", errorDefinition.getErrorVariableName(), xtw);
        if (errorDefinition.getErrorVariableLocalScope() != null) {
            this.writeQualifiedAttribute("errorVariableLocalScope", errorDefinition.getErrorVariableLocalScope().toString(), xtw);
        }
        if (errorDefinition.getErrorVariableTransient() != null) {
            this.writeQualifiedAttribute("errorVariableTransient", errorDefinition.getErrorVariableTransient().toString(), xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)errorDefinition, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeEscalationDefinition(Event parentEvent, EscalationEventDefinition escalationDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("escalationEventDefinition");
        this.writeDefaultAttribute("escalationRef", escalationDefinition.getEscalationCode(), xtw);
        boolean didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)escalationDefinition, false, model.getNamespaces(), xtw);
        if (didWriteExtensionStartElement) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected void writeTerminateDefinition(Event parentEvent, TerminateEventDefinition terminateDefinition, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionStartElement;
        xtw.writeStartElement("terminateEventDefinition");
        if (terminateDefinition.isTerminateAll()) {
            this.writeQualifiedAttribute("terminateAll", "true", xtw);
        }
        if (terminateDefinition.isTerminateMultiInstance()) {
            this.writeQualifiedAttribute("terminateMultiInstance", "true", xtw);
        }
        if (didWriteExtensionStartElement = BpmnXMLUtil.writeExtensionElements((BaseElement)terminateDefinition, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }

    protected boolean writeVariableListenerDefinition(Event parentEvent, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        EventDefinition eventDefinition;
        if (parentEvent.getEventDefinitions().size() == 1 && (eventDefinition = (EventDefinition)parentEvent.getEventDefinitions().iterator().next()) instanceof VariableListenerEventDefinition) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("flowable", "variableListenerEventDefinition", "http://flowable.org/bpmn");
            VariableListenerEventDefinition variableListenerEventDefinition = (VariableListenerEventDefinition)eventDefinition;
            if (StringUtils.isNotEmpty((CharSequence)variableListenerEventDefinition.getVariableName())) {
                this.writeDefaultAttribute("variableName", variableListenerEventDefinition.getVariableName(), xtw);
            }
            if (StringUtils.isNotEmpty((CharSequence)variableListenerEventDefinition.getVariableChangeType())) {
                this.writeDefaultAttribute("variableChangeType", variableListenerEventDefinition.getVariableChangeType(), xtw);
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        BpmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }

    protected void writeDataAssociation(String elementName, DataAssociation dataAssociation, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement(elementName);
        this.writeDefaultAttribute("id", dataAssociation.getId(), xtw);
        if (!StringUtils.isEmpty((CharSequence)dataAssociation.getSourceRef())) {
            xtw.writeStartElement("sourceRef");
            xtw.writeCharacters(dataAssociation.getSourceRef());
            xtw.writeEndElement();
        }
        xtw.writeStartElement("targetRef");
        xtw.writeCharacters(dataAssociation.getTargetRef());
        xtw.writeEndElement();
        if (!StringUtils.isEmpty((CharSequence)dataAssociation.getTransformation())) {
            xtw.writeStartElement("transformation");
            xtw.writeCharacters(dataAssociation.getTransformation());
            xtw.writeEndElement();
        }
        for (Assignment assignment : dataAssociation.getAssignments()) {
            xtw.writeStartElement("assignment");
            xtw.writeStartElement("from");
            xtw.writeCharacters(assignment.getFrom());
            xtw.writeEndElement();
            xtw.writeStartElement("to");
            xtw.writeCharacters(assignment.getTo());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }
}

