/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator.impl.deployer;

import java.util.Map;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.repository.CmmnDeploymentBuilder;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.EngineDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("CmmnDeployer: processing deployment {}", (Object)deployment.getName());
        CmmnDeploymentBuilder cmmnDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!org.flowable.cmmn.engine.impl.deployer.CmmnDeployer.isCmmnResource((String)resourceName)) continue;
            LOGGER.info("CmmnDeployer: processing resource {}", (Object)resourceName);
            if (cmmnDeploymentBuilder == null) {
                CmmnRepositoryService cmmnRepositoryService = CommandContextUtil.getCmmnRepositoryService();
                cmmnDeploymentBuilder = cmmnRepositoryService.createDeployment().name(deployment.getName());
            }
            cmmnDeploymentBuilder.addBytes(resourceName, ((EngineResource)resources.get(resourceName)).getBytes());
        }
        if (cmmnDeploymentBuilder != null) {
            cmmnDeploymentBuilder.parentDeploymentId(deployment.getId());
            cmmnDeploymentBuilder.key(deployment.getKey());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                cmmnDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            cmmnDeploymentBuilder.deploy();
        }
    }
}

