/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractMovePlanItemInstanceToTerminalStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class TerminatePlanItemInstanceOperation
extends AbstractMovePlanItemInstanceToTerminalStateOperation {
    protected String exitType;
    protected String exitEventType;

    public TerminatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String exitType, String exitEventType) {
        super(commandContext, planItemInstanceEntity);
        this.exitType = exitType;
        this.exitEventType = exitEventType;
    }

    @Override
    public String getNewState() {
        return "terminated";
    }

    @Override
    public String getLifeCycleTransition() {
        return "terminate";
    }

    @Override
    public boolean isEvaluateRepetitionRule() {
        return false;
    }

    @Override
    protected boolean shouldAggregateForSingleInstance() {
        return false;
    }

    @Override
    protected boolean shouldAggregateForMultipleInstances() {
        return false;
    }

    @Override
    protected void internalExecute() {
        this.planItemInstanceEntity.setEndedTime(this.getCurrentTime(this.commandContext));
        this.planItemInstanceEntity.setTerminatedTime(this.planItemInstanceEntity.getEndedTime());
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordPlanItemInstanceTerminated(this.planItemInstanceEntity);
    }

    @Override
    public String getOperationName() {
        return "[Terminate plan item]";
    }

    public String getExitType() {
        return this.exitType;
    }

    public void setExitType(String exitType) {
        this.exitType = exitType;
    }

    public String getExitEventType() {
        return this.exitEventType;
    }

    public void setExitEventType(String exitEventType) {
        this.exitEventType = exitEventType;
    }
}

