/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormService;

public abstract class AbstractNeedsPlanItemInstanceCmd
implements Command<Void>,
Serializable {
    protected String planItemInstanceId;
    protected Map<String, Object> variables;
    protected Map<String, Object> formVariables;
    protected String formOutcome;
    protected FormInfo formInfo;
    protected Map<String, Object> localVariables;
    protected Map<String, Object> transientVariables;

    public AbstractNeedsPlanItemInstanceCmd(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public AbstractNeedsPlanItemInstanceCmd(String planItemInstanceId, Map<String, Object> variables, Map<String, Object> formVariables, String formOutcome, FormInfo formInfo, Map<String, Object> localVariables, Map<String, Object> transientVariables) {
        this.planItemInstanceId = planItemInstanceId;
        this.variables = variables;
        this.formVariables = formVariables;
        this.formOutcome = formOutcome;
        this.formInfo = formInfo;
        this.localVariables = localVariables;
        this.transientVariables = transientVariables;
    }

    public Void execute(CommandContext commandContext) {
        if (this.planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Plan item instance id is null");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(this.planItemInstanceId);
        if (planItemInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("Cannot find plan item instance for id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        if (this.formInfo != null) {
            FormService formService = CommandContextUtil.getFormService(commandContext);
            if (formService == null) {
                throw new FlowableIllegalStateException("Form engine is not initialized");
            }
            Map variablesFromFormSubmission = formService.getVariablesFromFormSubmission(this.formInfo, this.formVariables, this.formOutcome);
            FormFieldHandler formFieldHandler = cmmnEngineConfiguration.getFormFieldHandler();
            formFieldHandler.handleFormFieldsOnSubmit(this.formInfo, null, null, planItemInstanceEntity.getCaseInstanceId(), "cmmn", variablesFromFormSubmission, planItemInstanceEntity.getTenantId());
            planItemInstanceEntity.setVariables(variablesFromFormSubmission);
        }
        if (this.variables != null) {
            planItemInstanceEntity.setVariables(this.variables);
        }
        if (this.localVariables != null) {
            planItemInstanceEntity.setVariablesLocal(this.localVariables);
        }
        if (this.transientVariables != null) {
            planItemInstanceEntity.setTransientVariables(this.transientVariables);
        }
        this.internalExecute(commandContext, planItemInstanceEntity);
        return null;
    }

    protected abstract void internalExecute(CommandContext var1, PlanItemInstanceEntity var2);

    public String getPlanItemInstanceId() {
        return this.planItemInstanceId;
    }

    public void setPlanItemInstanceId(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public void setTransientVariables(Map<String, Object> transientVariables) {
        this.transientVariables = transientVariables;
    }
}

