/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.delegate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.TaskWithFieldExtensions;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.FixedValue;

public class CmmnDelegateHelper {
    public static CmmnModel getCmmnModel(DelegatePlanItemInstance planItemInstance) {
        if (planItemInstance == null) {
            throw new FlowableException("Null planItemInstance passed");
        }
        return CaseDefinitionUtil.getCmmnModel(planItemInstance.getCaseDefinitionId());
    }

    public static CmmnElement getCmmnElement(DelegatePlanItemInstance planItemInstance) {
        CmmnModel cmmnModel = CmmnDelegateHelper.getCmmnModel(planItemInstance);
        CaseElement caseElement = null;
        if (planItemInstance.getPlanItem() != null && (caseElement = (CaseElement)cmmnModel.getPrimaryCase().getAllCaseElements().get(planItemInstance.getPlanItem().getId())) == null) {
            throw new FlowableException("Could not find a CmmnElement for id " + planItemInstance.getPlanItem().getId());
        }
        return caseElement;
    }

    public static boolean isExecutingLifecycleListener(DelegatePlanItemInstance planItemInstance) {
        return planItemInstance.getCurrentLifecycleListener() != null;
    }

    public static Map<String, List<ExtensionElement>> getExtensionElements(DelegatePlanItemInstance planItemInstance) {
        if (CmmnDelegateHelper.isExecutingLifecycleListener(planItemInstance)) {
            return CmmnDelegateHelper.getListenerExtensionElements(planItemInstance);
        }
        return CmmnDelegateHelper.getCmmnElementExtensionElements(planItemInstance);
    }

    public static Map<String, List<ExtensionElement>> getCmmnElementExtensionElements(DelegatePlanItemInstance planItemInstance) {
        return CmmnDelegateHelper.getCmmnElement(planItemInstance).getExtensionElements();
    }

    public static Map<String, List<ExtensionElement>> getListenerExtensionElements(DelegatePlanItemInstance planItemInstance) {
        if (planItemInstance.getCurrentFlowableListener() != null) {
            return planItemInstance.getCurrentFlowableListener().getExtensionElements();
        }
        return Collections.emptyMap();
    }

    public static List<FieldExtension> getFields(DelegatePlanItemInstance planItemInstance) {
        if (CmmnDelegateHelper.isExecutingLifecycleListener(planItemInstance)) {
            return CmmnDelegateHelper.getListenerFields(planItemInstance);
        }
        return CmmnDelegateHelper.getCmmnElementFields(planItemInstance);
    }

    public static List<FieldExtension> getCmmnElementFields(DelegatePlanItemInstance planItemInstance) {
        PlanItemDefinition planItemDefinition;
        CmmnElement cmmnElement = CmmnDelegateHelper.getCmmnElement(planItemInstance);
        if (cmmnElement instanceof TaskWithFieldExtensions) {
            return ((TaskWithFieldExtensions)cmmnElement).getFieldExtensions();
        }
        if (cmmnElement instanceof PlanItem && (planItemDefinition = ((PlanItem)cmmnElement).getPlanItemDefinition()) instanceof TaskWithFieldExtensions) {
            return ((TaskWithFieldExtensions)planItemDefinition).getFieldExtensions();
        }
        return new ArrayList<FieldExtension>();
    }

    public static List<FieldExtension> getListenerFields(DelegatePlanItemInstance planItemInstance) {
        if (planItemInstance.getCurrentFlowableListener() != null) {
            return planItemInstance.getCurrentFlowableListener().getFieldExtensions();
        }
        return Collections.emptyList();
    }

    public static FieldExtension getField(DelegatePlanItemInstance planItemInstance, String fieldName) {
        if (CmmnDelegateHelper.isExecutingLifecycleListener(planItemInstance)) {
            return CmmnDelegateHelper.getListenerField(planItemInstance, fieldName);
        }
        return CmmnDelegateHelper.getCmmnElementField(planItemInstance, fieldName);
    }

    public static FieldExtension getCmmnElementField(DelegatePlanItemInstance planItemInstance, String fieldName) {
        List<FieldExtension> fieldExtensions = CmmnDelegateHelper.getCmmnElementFields(planItemInstance);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static FieldExtension getListenerField(DelegatePlanItemInstance planItemInstance, String fieldName) {
        List<FieldExtension> fieldExtensions = CmmnDelegateHelper.getListenerFields(planItemInstance);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static Expression createExpressionForField(FieldExtension fieldExtension) {
        if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) {
            ExpressionManager expressionManager = CommandContextUtil.getCmmnEngineConfiguration().getExpressionManager();
            return expressionManager.createExpression(fieldExtension.getExpression());
        }
        return new FixedValue((Object)fieldExtension.getStringValue());
    }

    public static Expression getFieldExpression(DelegatePlanItemInstance planItemInstance, String fieldName) {
        if (CmmnDelegateHelper.isExecutingLifecycleListener(planItemInstance)) {
            return CmmnDelegateHelper.getListenerFieldExpression(planItemInstance, fieldName);
        }
        return CmmnDelegateHelper.getCmmnElementFieldExpression(planItemInstance, fieldName);
    }

    public static Expression getCmmnElementFieldExpression(DelegatePlanItemInstance planItemInstance, String fieldName) {
        FieldExtension fieldExtension = CmmnDelegateHelper.getCmmnElementField(planItemInstance, fieldName);
        if (fieldExtension != null) {
            return CmmnDelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }

    public static Expression getListenerFieldExpression(DelegatePlanItemInstance planItemInstance, String fieldName) {
        FieldExtension fieldExtension = CmmnDelegateHelper.getListenerField(planItemInstance, fieldName);
        if (fieldExtension != null) {
            return CmmnDelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }
}

