/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.function;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.PlanItemInstanceContainerUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.api.delegate.FlowableFunctionDelegate;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstFunction;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstParameters;
import org.flowable.common.engine.impl.el.FlowableAstFunctionCreator;
import org.flowable.common.engine.impl.el.FlowableExpressionParser;

public class IsStageCompletableExpressionFunction
implements FlowableFunctionDelegate,
FlowableAstFunctionCreator {
    public String prefix() {
        return "cmmn";
    }

    public String localName() {
        return "isStageCompletable";
    }

    public Method functionMethod() {
        try {
            return IsStageCompletableExpressionFunction.class.getMethod("isStageCompletable", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find isStageCompletable function", e);
        }
    }

    public Collection<String> getFunctionNames() {
        return Collections.singleton(this.prefix() + ":" + this.localName());
    }

    public AstFunction createFunction(String name, int index, AstParameters parameters, boolean varargs, FlowableExpressionParser parser) {
        if (parameters.getCardinality() == 0) {
            AstParameters newParameters = new AstParameters(Collections.singletonList(parser.createIdentifier("planItemInstance")));
            return new AstFunction(name, index, newParameters, varargs);
        }
        return new AstFunction(name, index, parameters, varargs);
    }

    public static boolean isStageCompletable(Object object) {
        if (object instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)object;
            if (planItemInstanceEntity.isStage()) {
                return planItemInstanceEntity.isCompletable();
            }
            if (planItemInstanceEntity.getStageInstanceId() != null) {
                PlanItemInstanceEntity stagePlanItemInstanceEntity = planItemInstanceEntity.getStagePlanItemInstanceEntity();
                PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
                if (planItemDefinition instanceof EventListener && ("available".equals(planItemInstanceEntity.getState()) || "unavailable".equals(planItemInstanceEntity.getState())) && StringUtils.isNotEmpty((CharSequence)((EventListener)planItemDefinition).getAvailableConditionExpression())) {
                    return PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(stagePlanItemInstanceEntity, Collections.singletonList(planItemInstanceEntity.getId()), true).isCompletable();
                }
                return stagePlanItemInstanceEntity.isCompletable();
            }
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager().findById(planItemInstanceEntity.getCaseInstanceId());
            return caseInstanceEntity.isCompletable();
        }
        if (object instanceof CaseInstanceEntity) {
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)object;
            return caseInstanceEntity.isCompletable();
        }
        return false;
    }
}

