/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.listener.CaseInstanceLifecycleListener;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.engine.impl.listener.CmmnListenerFactory;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CmmnListenerNotificationHelper {
    public void executeTaskListeners(TaskEntity taskEntity, String eventType) {
        CmmnModel cmmnModel;
        CaseElement caseElement;
        if (taskEntity.getScopeDefinitionId() != null && (caseElement = (CaseElement)(cmmnModel = CaseDefinitionUtil.getCmmnModel(taskEntity.getScopeDefinitionId())).getPrimaryCase().getAllCaseElements().get(taskEntity.getTaskDefinitionKey())) instanceof HumanTask) {
            HumanTask humanTask = (HumanTask)caseElement;
            this.executeTaskListeners(humanTask, taskEntity, eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskListeners(HumanTask humanTask, TaskEntity taskEntity, String eventType) {
        for (FlowableListener listener : humanTask.getTaskListeners()) {
            String event = listener.getEvent();
            if (!event.equals(eventType) && !event.equals("all")) continue;
            TaskListener taskListener = this.createTaskListener(listener);
            taskEntity.setEventName(eventType);
            taskEntity.setEventHandlerId(listener.getId());
            try {
                taskListener.notify((DelegateTask)taskEntity);
            }
            finally {
                taskEntity.setEventName(null);
            }
        }
    }

    protected TaskListener createTaskListener(FlowableListener listener) {
        TaskListener taskListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createClassDelegateTaskListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createExpressionTaskListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createDelegateExpressionTaskListener(listener);
        } else if ("instance".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = (TaskListener)listener.getInstance();
        }
        return taskListener;
    }

    protected PlanItemInstanceLifecycleListener createLifecycleListener(FlowableListener listener) {
        PlanItemInstanceLifecycleListener lifecycleListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createClassDelegateLifeCycleListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createExpressionLifeCycleListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createDelegateExpressionLifeCycleListener(listener);
        } else if ("instance".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = (PlanItemInstanceLifecycleListener)listener.getInstance();
        }
        return lifecycleListener;
    }

    public void executeLifecycleListeners(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        Map<String, List<PlanItemInstanceLifecycleListener>> planItemInstanceLifeCycleListeners;
        List flowableListeners;
        if (Objects.equals(oldState, newState)) {
            return;
        }
        PlanItemDefinition planItemDefinition = planItemInstance.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition != null && (flowableListeners = planItemDefinition.getLifecycleListeners()) != null && !flowableListeners.isEmpty()) {
            for (FlowableListener flowableListener : flowableListeners) {
                if (!this.stateMatches(flowableListener.getSourceState(), oldState) || !this.stateMatches(flowableListener.getTargetState(), newState)) continue;
                PlanItemInstanceLifecycleListener lifecycleListener = this.createLifecycleListener(flowableListener);
                this.executeLifecycleListener(planItemInstance, oldState, newState, lifecycleListener, flowableListener);
            }
        }
        if ((planItemInstanceLifeCycleListeners = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getPlanItemInstanceLifecycleListeners()) != null && !planItemInstanceLifeCycleListeners.isEmpty()) {
            List<PlanItemInstanceLifecycleListener> specificListeners = planItemInstanceLifeCycleListeners.get(planItemInstance.getPlanItemDefinitionType());
            this.executeListeners(specificListeners, planItemInstance, oldState, newState);
            List<PlanItemInstanceLifecycleListener> genericListeners = planItemInstanceLifeCycleListeners.get(null);
            this.executeListeners(genericListeners, planItemInstance, oldState, newState);
        }
    }

    public void executeListeners(List<PlanItemInstanceLifecycleListener> listeners, DelegatePlanItemInstance planItemInstance, String oldState, String newState) {
        if (listeners != null) {
            for (PlanItemInstanceLifecycleListener listener : listeners) {
                this.executeLifecycleListener(planItemInstance, oldState, newState, listener, null);
            }
        }
    }

    public void executeLifecycleListener(DelegatePlanItemInstance planItemInstance, String oldState, String newState, PlanItemInstanceLifecycleListener lifecycleListener, FlowableListener flowableListener) {
        if (this.lifecycleListenerMatches(lifecycleListener, oldState, newState)) {
            planItemInstance.setCurrentLifecycleListener(lifecycleListener, flowableListener);
            lifecycleListener.stateChanged(planItemInstance, oldState, newState);
            planItemInstance.setCurrentLifecycleListener(null, null);
        }
    }

    protected boolean lifecycleListenerMatches(PlanItemInstanceLifecycleListener lifecycleListener, String oldState, String newState) {
        return this.stateMatches(lifecycleListener.getSourceState(), oldState) && this.stateMatches(lifecycleListener.getTargetState(), newState);
    }

    protected boolean stateMatches(String listenerExpectedState, String actualState) {
        return StringUtils.isEmpty((CharSequence)listenerExpectedState) || Objects.equals(actualState, listenerExpectedState);
    }

    protected CaseInstanceLifecycleListener createCaseLifecycleListener(FlowableListener listener) {
        CaseInstanceLifecycleListener lifecycleListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createClassDelegateCaseLifeCycleListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createExpressionCaseLifeCycleListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createDelegateExpressionCaseLifeCycleListener(listener);
        } else if ("instance".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = (CaseInstanceLifecycleListener)listener.getInstance();
        }
        return lifecycleListener;
    }
}

