/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.dmn.engine.impl.parser.DmnParse;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;

public class ParsedDeployment {
    protected DmnDeploymentEntity deploymentEntity;
    protected List<DecisionEntity> decisions;
    protected Map<DecisionEntity, DmnParse> mapDecisionsToParses;
    protected Map<DecisionEntity, EngineResource> mapDecisionsToResources;

    public ParsedDeployment(DmnDeploymentEntity entity, List<DecisionEntity> decisions, Map<DecisionEntity, DmnParse> mapDecisionsToParses, Map<DecisionEntity, EngineResource> mapDecisionsToResources) {
        this.deploymentEntity = entity;
        this.decisions = decisions;
        this.mapDecisionsToParses = mapDecisionsToParses;
        this.mapDecisionsToResources = mapDecisionsToResources;
    }

    public DmnDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<DecisionEntity> getAllDecisions() {
        return this.decisions;
    }

    public EngineResource getResourceForDecision(DecisionEntity decision) {
        return this.mapDecisionsToResources.get(decision);
    }

    public DmnParse getDmnParseForDecision(DecisionEntity decision) {
        return this.mapDecisionsToParses.get(decision);
    }

    public DmnDefinition getDmnDefinitionForDecision(DecisionEntity decision) {
        DmnParse parse = this.getDmnParseForDecision(decision);
        return parse == null ? null : parse.getDmnDefinition();
    }

    public DecisionService getDecisionServiceForDecisionEntity(DecisionEntity decisionEntity) {
        DmnDefinition dmnDefinition = this.getDmnDefinitionForDecision(decisionEntity);
        return dmnDefinition == null ? null : dmnDefinition.getDecisionServiceById(decisionEntity.getKey());
    }

    public Decision getDecisionForDecisionEntity(DecisionEntity decisionEntity) {
        DmnDefinition dmnDefinition = this.getDmnDefinitionForDecision(decisionEntity);
        return dmnDefinition == null ? null : dmnDefinition.getDecisionById(decisionEntity.getKey());
    }
}

