/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.DecisionQueryImpl;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityImpl;
import org.flowable.dmn.engine.impl.persistence.entity.data.AbstractDmnDataManager;
import org.flowable.dmn.engine.impl.persistence.entity.data.DecisionDataManager;

public class MybatisDecisionDataManager
extends AbstractDmnDataManager<DecisionEntity>
implements DecisionDataManager {
    public MybatisDecisionDataManager(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    public Class<? extends DecisionEntity> getManagedEntityClass() {
        return DecisionEntityImpl.class;
    }

    public DecisionEntity create() {
        return new DecisionEntityImpl();
    }

    @Override
    public DecisionEntity findLatestDecisionByKey(String decisionKey) {
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectLatestDecisionByKey", (Object)decisionKey);
    }

    @Override
    public DecisionEntity findLatestDecisionByKeyAndTenantId(String decisionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionKey", decisionKey);
        params.put("tenantId", tenantId);
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectLatestDecisionByKeyAndTenantId", params);
    }

    @Override
    public DecisionEntity findLatestDecisionByKeyAndParentDeploymentId(String decisionKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionKey", decisionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectLatestDecisionByKeyAndParentDeploymentId", params);
    }

    @Override
    public DecisionEntity findLatestDecisionByKeyParentDeploymentIdAndTenantId(String decisionKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("decisionKey", decisionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectLatestDecisionByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteDecisionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteDecisionsByDeploymentId", (Object)deploymentId, this.getManagedEntityClass());
    }

    @Override
    public List<DmnDecision> findDecisionsByQueryCriteria(DecisionQueryImpl DecisionQuery) {
        return this.getDbSqlSession().selectList("selectDecisionsByQueryCriteria", (ListQueryParameterObject)DecisionQuery);
    }

    @Override
    public long findDecisionCountByQueryCriteria(DecisionQueryImpl DecisionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDecisionCountByQueryCriteria", (Object)DecisionQuery);
    }

    @Override
    public DecisionEntity findDecisionByDeploymentAndKey(String deploymentId, String decisionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionKey", decisionKey);
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectDecisionByDeploymentAndKey", parameters);
    }

    @Override
    public DecisionEntity findDecisionByDeploymentAndKeyAndTenantId(String deploymentId, String decisionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionKey", decisionKey);
        parameters.put("tenantId", tenantId);
        return (DecisionEntity)this.getDbSqlSession().selectOne("selectDecisionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public DecisionEntity findDecisionByKeyAndVersion(String decisionKey, Integer decisionVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("decisionKey", decisionKey);
        params.put("decisionVersion", decisionVersion);
        List results = this.getDbSqlSession().selectList("selectDecisionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (DecisionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " decision tables with key = '" + decisionKey + "' and version = '" + decisionVersion + "'.");
        }
        return null;
    }

    @Override
    public DecisionEntity findDecisionByKeyAndVersionAndTenantId(String decisionKey, Integer decisionVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("decisionKey", decisionKey);
        params.put("decisionVersion", decisionVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectDecisionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (DecisionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " decisions with key = '" + decisionKey + "' and version = '" + decisionVersion + "'.");
        }
        return null;
    }

    @Override
    public List<DmnDecision> findDecisionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDecisionByNativeQuery", parameterMap);
    }

    @Override
    public long findDecisionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDecisionCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateDecisionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateDecisionTenantIdForDeploymentId", params);
    }
}

