/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDiDiagram;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.dmn.model.InputData;
import org.flowable.dmn.model.ItemDefinition;
import org.flowable.dmn.model.NamedElement;

public class DmnDefinition
extends NamedElement {
    protected String expressionLanguage;
    protected String typeLanguage;
    protected String namespace;
    protected String exporter;
    protected String exporterVersion;
    protected List<InputData> inputData = new ArrayList<InputData>();
    protected List<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
    protected List<Decision> decisions = new ArrayList<Decision>();
    protected List<DecisionService> decisionServices = new ArrayList<DecisionService>();
    protected Map<String, DmnDiDiagram> diDiagrams = new LinkedHashMap<String, DmnDiDiagram>();
    protected Map<String, GraphicInfo> locationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, Map<String, GraphicInfo>> locationByDiagramIdMap = new LinkedHashMap<String, Map<String, GraphicInfo>>();
    protected Map<String, GraphicInfo> labelLocationMap = new LinkedHashMap<String, GraphicInfo>();
    protected Map<String, Map<String, GraphicInfo>> labelLocationByDiagramIdMap = new LinkedHashMap<String, Map<String, GraphicInfo>>();
    protected Map<String, List<GraphicInfo>> flowLocationMap = new LinkedHashMap<String, List<GraphicInfo>>();
    protected Map<String, Map<String, List<GraphicInfo>>> flowLocationByDiagramIdMap = new LinkedHashMap<String, Map<String, List<GraphicInfo>>>();
    protected Map<String, List<GraphicInfo>> decisionServiceDividerLocationMap = new LinkedHashMap<String, List<GraphicInfo>>();
    protected Map<String, Map<String, List<GraphicInfo>>> decisionServiceDividerLocationByDiagramIdMap = new LinkedHashMap<String, Map<String, List<GraphicInfo>>>();

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getTypeLanguage() {
        return this.typeLanguage;
    }

    public void setTypeLanguage(String typeLanguage) {
        this.typeLanguage = typeLanguage;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<InputData> getInputData() {
        return this.inputData;
    }

    public void setInputData(List<InputData> inputData) {
        this.inputData = inputData;
    }

    public void addInputData(InputData inputData) {
        this.inputData.add(inputData);
    }

    public void setItemDefinitions(List<ItemDefinition> itemDefinitions) {
        this.itemDefinitions = itemDefinitions;
    }

    public List<ItemDefinition> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public void addItemDefinition(ItemDefinition itemDefinition) {
        this.itemDefinitions.add(itemDefinition);
    }

    public List<Decision> getDecisions() {
        return this.decisions;
    }

    public void addDecision(Decision decision) {
        this.decisions.add(decision);
    }

    public Decision getDecisionById(String id) {
        for (Decision decision : this.decisions) {
            if (!id.equals(decision.getId())) continue;
            return decision;
        }
        return null;
    }

    public List<DecisionService> getDecisionServices() {
        return this.decisionServices;
    }

    public void addDecisionService(DecisionService decisionService) {
        this.decisionServices.add(decisionService);
    }

    public DecisionService getDecisionServiceById(String id) {
        for (DecisionService decisionService : this.decisionServices) {
            if (!id.equals(decisionService.getId())) continue;
            return decisionService;
        }
        return null;
    }

    public DmnDiDiagram getDiDiagram(String diagramId) {
        return this.diDiagrams.get(diagramId);
    }

    public Map<String, DmnDiDiagram> getDiDiagramMap() {
        return this.diDiagrams;
    }

    public void addDiDiagram(DmnDiDiagram diDiagram) {
        this.diDiagrams.put(diDiagram.getId(), diDiagram);
    }

    public void addGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.locationMap.put(key, graphicInfo);
    }

    public void addGraphicInfoByDiagramId(String diagramId, String key, GraphicInfo graphicInfo) {
        this.locationByDiagramIdMap.computeIfAbsent(diagramId, k -> new LinkedHashMap());
        this.locationByDiagramIdMap.get(diagramId).put(key, graphicInfo);
        this.locationMap.put(key, graphicInfo);
    }

    public GraphicInfo getGraphicInfo(String key) {
        return this.locationMap.get(key);
    }

    public GraphicInfo getGraphicInfoByDiagramId(String diagramId, String key) {
        return this.locationByDiagramIdMap.get(diagramId).get(key);
    }

    public Map<String, GraphicInfo> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, Map<String, GraphicInfo>> getLocationByDiagramIdMap() {
        return this.locationByDiagramIdMap;
    }

    public Map<String, GraphicInfo> getLocationMapByDiagramId(String diagramId) {
        return this.locationByDiagramIdMap.get(diagramId);
    }

    public void removeLocationByDiagramId(String diagramId) {
        this.locationByDiagramIdMap.remove(diagramId);
    }

    public List<GraphicInfo> getFlowLocationGraphicInfo(String key) {
        return this.flowLocationMap.get(key);
    }

    public Map<String, List<GraphicInfo>> getFlowLocationMap() {
        return this.flowLocationMap;
    }

    public Map<String, List<GraphicInfo>> getFlowLocationMapByDiagramId(String diagramId) {
        return this.flowLocationByDiagramIdMap.get(diagramId);
    }

    public Map<String, Map<String, List<GraphicInfo>>> getFlowLocationByDiagramIdMap() {
        return this.flowLocationByDiagramIdMap;
    }

    public void removeFlowLocationByDiagramId(String diagramId) {
        this.flowLocationByDiagramIdMap.remove(diagramId);
    }

    public void addFlowGraphicInfoList(String key, List<GraphicInfo> graphicInfoList) {
        this.flowLocationMap.put(key, graphicInfoList);
    }

    public void addFlowGraphicInfoListByDiagramId(String diagramId, String key, List<GraphicInfo> graphicInfoList) {
        this.flowLocationByDiagramIdMap.computeIfAbsent(diagramId, k -> new LinkedHashMap());
        this.flowLocationByDiagramIdMap.get(diagramId).put(key, graphicInfoList);
        this.flowLocationMap.put(key, graphicInfoList);
    }

    public Map<String, Map<String, GraphicInfo>> getLabelLocationByDiagramIdMap() {
        return this.labelLocationByDiagramIdMap;
    }

    public Map<String, GraphicInfo> getLabelLocationByDiagramId(String diagramId) {
        return this.labelLocationByDiagramIdMap.get(diagramId);
    }

    public void addLabelGraphicInfo(String key, GraphicInfo graphicInfo) {
        this.labelLocationMap.put(key, graphicInfo);
    }

    public void addLabelGraphicInfoByDiagramId(String diagramId, String key, GraphicInfo graphicInfo) {
        this.labelLocationByDiagramIdMap.computeIfAbsent(diagramId, k -> new LinkedHashMap());
        this.labelLocationByDiagramIdMap.get(diagramId).put(key, graphicInfo);
        this.labelLocationMap.put(key, graphicInfo);
    }

    public void removeLabelGraphicInfo(String key) {
        this.flowLocationMap.remove(key);
    }

    public Map<String, Map<String, List<GraphicInfo>>> getDecisionServiceDividerLocationByDiagramIdMap() {
        return this.decisionServiceDividerLocationByDiagramIdMap;
    }

    public Map<String, List<GraphicInfo>> getDecisionServiceDividerLocationMapByDiagramId(String diagramId) {
        return this.decisionServiceDividerLocationByDiagramIdMap.get(diagramId);
    }

    public Map<String, List<GraphicInfo>> getDecisionServiceDividerLocationMap() {
        return this.decisionServiceDividerLocationMap;
    }

    public List<GraphicInfo> getDecisionServiceDividerGraphicInfo(String key) {
        return this.decisionServiceDividerLocationMap.get(key);
    }

    public void addDecisionServiceDividerGraphicInfoList(String key, List<GraphicInfo> graphicInfoList) {
        this.decisionServiceDividerLocationMap.put(key, graphicInfoList);
    }

    public void addDecisionServiceDividerGraphicInfoListByDiagramId(String diagramId, String key, List<GraphicInfo> graphicInfoList) {
        this.decisionServiceDividerLocationByDiagramIdMap.computeIfAbsent(diagramId, k -> new LinkedHashMap());
        this.decisionServiceDividerLocationByDiagramIdMap.get(diagramId).put(key, graphicInfoList);
        this.decisionServiceDividerLocationMap.put(key, graphicInfoList);
    }

    public String getExporter() {
        return this.exporter;
    }

    public void setExporter(String exporter) {
        this.exporter = exporter;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public void setExporterVersion(String exporterVersion) {
        this.exporterVersion = exporterVersion;
    }
}

