/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring.autodeployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.engine.DmnEngine;
import org.springframework.core.io.Resource;

public abstract class AbstractDmnAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<DmnEngine> {
    public AbstractDmnAutoDeploymentStrategy() {
    }

    public AbstractDmnAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(DmnEngine engine, String deploymentNameHint) {
        return engine.getDmnEngineConfiguration().getLockManager(this.determineLockName(deploymentNameHint));
    }

    protected void addResource(Resource resource, DmnDeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, DmnDeploymentBuilder deploymentBuilder) {
        try (InputStream inputStream = resource.getInputStream();){
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read resource " + resource, ex);
        }
    }
}

