/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.RuleOutputClauseContainer;

public class OutputEntryParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "outputEntry";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, Decision decision) throws Exception {
        if (!(parentElement instanceof DecisionRule)) {
            return;
        }
        DecisionRule rule = (DecisionRule)parentElement;
        LiteralExpression outputEntry = new LiteralExpression();
        outputEntry.setId(xtr.getAttributeValue(null, "id"));
        boolean readyWithOutputEntry = false;
        try {
            while (!readyWithOutputEntry && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    outputEntry.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithOutputEntry = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing output entry", (Throwable)e);
        }
        OutputClause outputClause = null;
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getOutputs() != null && decisionTable.getOutputs().get(rule.getOutputEntries().size()) != null) {
            outputClause = (OutputClause)decisionTable.getOutputs().get(rule.getOutputEntries().size());
        }
        if (outputClause == null) {
            LOGGER.warn("Error determine output clause for position: {}", (Object)decisionTable.getOutputs());
        }
        RuleOutputClauseContainer outputContainer = new RuleOutputClauseContainer();
        outputContainer.setOutputClause(outputClause);
        outputContainer.setOutputEntry(outputEntry);
        rule.addOutputEntry(outputContainer);
    }
}

