/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.test;

import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExtension.class);
    private static final String EMPTY_LINE = "\n";

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        LOGGER.debug(EMPTY_LINE);
        LOGGER.debug("#### START {}.{} ###########################################################", (Object)context.getRequiredTestClass().getSimpleName(), (Object)context.getRequiredTestMethod().getName());
    }

    public void afterTestExecution(ExtensionContext context) throws Exception {
        context.getExecutionException().ifPresent(LoggingExtension::logExecutionException);
        LOGGER.debug("#### END {}.{} ###########################################################", (Object)context.getRequiredTestClass().getSimpleName(), (Object)context.getRequiredTestMethod().getName());
        LOGGER.debug(EMPTY_LINE);
    }

    protected static void logExecutionException(Throwable ex) {
        if (ex instanceof AssertionError) {
            LOGGER.error(EMPTY_LINE);
            LOGGER.error("ASSERTION FAILED: {}", (Object)ex, (Object)ex);
        } else {
            LOGGER.error(EMPTY_LINE);
            LOGGER.error("EXCEPTION: {}", (Object)ex, (Object)ex);
        }
    }
}

