/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.debug.ExecutionTreeUtil;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.delegate.TriggerableActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class EvaluateConditionalEventsOperation
extends AbstractOperation {
    public EvaluateConditionalEventsOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        ArrayList<ExecutionEntity> allExecutions = new ArrayList<ExecutionEntity>();
        ExecutionTreeUtil.collectChildExecutions(this.execution, allExecutions);
        String processDefinitionId = this.execution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        List eventSubProcesses = process.findFlowElementsOfType(EventSubProcess.class, false);
        this.evaluateEventSubProcesses(eventSubProcesses, this.execution);
        for (ExecutionEntity childExecutionEntity : allExecutions) {
            String activityId = childExecutionEntity.getCurrentActivityId();
            FlowElement currentFlowElement = process.getFlowElement(activityId, true);
            if (currentFlowElement != null && currentFlowElement instanceof Event) {
                ActivityBehavior activityBehavior;
                Event event = (Event)currentFlowElement;
                if (event.getEventDefinitions().isEmpty() || !(event.getEventDefinitions().get(0) instanceof ConditionalEventDefinition) || !((activityBehavior = (ActivityBehavior)((FlowNode)currentFlowElement).getBehavior()) instanceof TriggerableActivityBehavior)) continue;
                ((TriggerableActivityBehavior)activityBehavior).trigger(childExecutionEntity, null, null);
                continue;
            }
            if (currentFlowElement == null || !(currentFlowElement instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)currentFlowElement;
            List childEventSubProcesses = subProcess.findAllSubFlowElementInFlowMapOfType(EventSubProcess.class);
            this.evaluateEventSubProcesses(childEventSubProcesses, childExecutionEntity);
        }
    }

    protected void evaluateEventSubProcesses(List<EventSubProcess> eventSubProcesses, ExecutionEntity parentExecution) {
        if (eventSubProcesses != null) {
            for (EventSubProcess eventSubProcess : eventSubProcesses) {
                List startEvents = eventSubProcess.findAllSubFlowElementInFlowMapOfType(StartEvent.class);
                if (startEvents == null) continue;
                for (StartEvent startEvent : startEvents) {
                    if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().isEmpty() || !(startEvent.getEventDefinitions().get(0) instanceof ConditionalEventDefinition)) continue;
                    CommandContext commandContext = CommandContextUtil.getCommandContext();
                    ConditionalEventDefinition conditionalEventDefinition = (ConditionalEventDefinition)startEvent.getEventDefinitions().get(0);
                    boolean conditionIsTrue = false;
                    String conditionExpression = conditionalEventDefinition.getConditionExpression();
                    if (StringUtils.isNotEmpty((CharSequence)conditionExpression)) {
                        Expression expression = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager().createExpression(conditionExpression);
                        Object result = expression.getValue((VariableContainer)parentExecution);
                        if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                            conditionIsTrue = true;
                        }
                    } else {
                        conditionIsTrue = true;
                    }
                    if (!conditionIsTrue) continue;
                    ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
                    if (startEvent.isInterrupting()) {
                        executionEntityManager.deleteChildExecutions(parentExecution, null, true);
                    }
                    ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
                    eventSubProcessExecution.setScope(true);
                    eventSubProcessExecution.setCurrentFlowElement((FlowElement)eventSubProcess);
                    ExecutionEntity startEventSubProcessExecution = executionEntityManager.createChildExecution(eventSubProcessExecution);
                    startEventSubProcessExecution.setCurrentFlowElement((FlowElement)startEvent);
                    CommandContextUtil.getAgenda(commandContext).planContinueProcessOperation(startEventSubProcessExecution);
                }
            }
        }
    }
}

