/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmmn.CaseInstanceService;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseTaskActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseTaskActivityBehavior.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CaseServiceTask caseServiceTask = (CaseServiceTask)executionEntity.getCurrentFlowElement();
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        CaseInstanceService caseInstanceService = processEngineConfiguration.getCaseInstanceService();
        if (caseInstanceService == null) {
            throw new FlowableException("To use the case service task a CaseInstanceService implementation needs to be available in the process engine configuration");
        }
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)caseServiceTask.getBusinessKey())) {
            Expression expression = expressionManager.createExpression(caseServiceTask.getBusinessKey());
            businessKey = expression.getValue((VariableContainer)execution).toString();
        } else if (caseServiceTask.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        String caseInstanceName = null;
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceName())) {
            Expression caseInstanceNameExpression = expressionManager.createExpression(caseServiceTask.getCaseInstanceName());
            caseInstanceName = caseInstanceNameExpression.getValue((VariableContainer)execution).toString();
        }
        HashMap<String, Object> inParameters = new HashMap<String, Object>();
        for (IOParameter inParameter : caseServiceTask.getInParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(inParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)execution);
            } else {
                value = execution.getVariable(inParameter.getSource());
            }
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getTargetExpression())) {
                Expression expression = expressionManager.createExpression(inParameter.getTargetExpression());
                Object variableNameValue = expression.getValue((VariableContainer)execution);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("In parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)inParameter.getTargetExpression());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)inParameter.getTarget())) {
                variableName = inParameter.getTarget();
            }
            inParameters.put(variableName, value);
        }
        String caseInstanceId = caseInstanceService.generateNewCaseInstanceId();
        if (processEngineConfiguration.isEnableEntityLinks()) {
            EntityLinkUtil.copyExistingEntityLinks(execution.getProcessInstanceId(), caseInstanceId, "cmmn");
            EntityLinkUtil.createNewEntityLink(execution.getProcessInstanceId(), caseInstanceId, "cmmn");
        }
        caseInstanceService.startCaseInstanceByKey(caseServiceTask.getCaseDefinitionKey(), caseInstanceId, caseInstanceName, businessKey, execution.getId(), execution.getTenantId(), caseServiceTask.isFallbackToDefaultTenant(), inParameters);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
    }

    public void triggerCaseTask(DelegateExecution execution, Map<String, Object> variables) {
        execution.setVariables(variables);
        this.leave(execution);
    }
}

