/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.entity.AttachmentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.task.Attachment;

public class SaveAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Attachment attachment;

    public SaveAttachmentCmd(Attachment attachment) {
        this.attachment = attachment;
    }

    public Object execute(CommandContext commandContext) {
        ExecutionEntity process;
        AttachmentEntity updateAttachment = (AttachmentEntity)CommandContextUtil.getAttachmentEntityManager().findById(this.attachment.getId());
        String processInstanceId = updateAttachment.getProcessInstanceId();
        String processDefinitionId = null;
        if (updateAttachment.getProcessInstanceId() != null && (process = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(processInstanceId)) != null) {
            processDefinitionId = process.getProcessDefinitionId();
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, process.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.saveAttachment(this.attachment);
                return null;
            }
        }
        updateAttachment.setName(this.attachment.getName());
        updateAttachment.setDescription(this.attachment.getDescription());
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, this.attachment, processInstanceId, processInstanceId, processDefinitionId));
        }
        return null;
    }
}

