/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandInvoker.class);

    public <T> T execute(CommandConfig config, final Command<T> command) {
        final CommandContext commandContext = Context.getCommandContext();
        FlowableEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        if (commandContext.isReused() && !agenda.isEmpty()) {
            return (T)command.execute(commandContext);
        }
        agenda.planOperation(new Runnable(){

            @Override
            public void run() {
                commandContext.setResult(command.execute(commandContext));
            }
        });
        this.executeOperations(commandContext);
        if (!commandContext.isReused() && CommandContextUtil.hasInvolvedExecutions(commandContext)) {
            agenda.planExecuteInactiveBehaviorsOperation();
            this.executeOperations(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext) {
        while (!CommandContextUtil.getAgenda(commandContext).isEmpty()) {
            Runnable runnable = CommandContextUtil.getAgenda(commandContext).getNextOperation();
            this.executeOperation(runnable);
        }
    }

    public void executeOperation(Runnable runnable) {
        if (runnable instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)runnable;
            if (operation.getExecution() == null || !operation.getExecution().isEnded()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing operation {}", operation.getClass());
                }
                runnable.run();
            }
        } else {
            runnable.run();
        }
    }

    public CommandInterceptor getNext() {
        return null;
    }

    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }
}

