/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.test.CleanTest;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.DefaultHistoryManager;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.test.AbstractFlowableTestCase;
import org.flowable.engine.impl.test.TestHelper;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.test.DeploymentId;
import org.flowable.job.api.HistoryJob;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableExtension
implements AfterEachCallback,
BeforeEachCallback,
AfterAllCallback,
ParameterResolver {
    protected static final String ANNOTATION_DEPLOYMENT_ID_KEY = "deploymentIdFromDeploymentAnnotation";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        ProcessEngine processEngine = this.getProcessEngine(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), org.flowable.engine.test.Deployment.class).ifPresent(deployment -> {
            String deploymentIdFromDeploymentAnnotation = TestHelper.annotationDeploymentSetUp(processEngine, context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            this.getStore(context).put((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), (Object)deploymentIdFromDeploymentAnnotation);
        });
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ProcessEngine processEngine = this.getProcessEngine(context);
        processEngine.getIdentityService().setAuthenticatedUserId(null);
        try {
            AbstractFlowableTestCase.validateHistoryData(processEngine);
        }
        finally {
            this.doFinally(context, TestInstance.Lifecycle.PER_METHOD);
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.doFinally(context, TestInstance.Lifecycle.PER_CLASS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFinally(ExtensionContext context, TestInstance.Lifecycle lifecycleForClean) {
        ProcessEngine processEngine = this.getProcessEngine(context);
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        boolean isAsyncHistoryEnabled = processEngineConfiguration.isAsyncHistoryEnabled();
        if (isAsyncHistoryEnabled) {
            ManagementService managementService = processEngine.getManagementService();
            List jobs = managementService.createHistoryJobQuery().list();
            for (HistoryJob job : jobs) {
                managementService.deleteHistoryJob(job.getId());
            }
        }
        HistoryManager asyncHistoryManager = null;
        try {
            if (isAsyncHistoryEnabled) {
                processEngineConfiguration.setAsyncHistoryEnabled(false);
                asyncHistoryManager = processEngineConfiguration.getHistoryManager();
                processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(processEngineConfiguration, processEngineConfiguration.getHistoryLevel(), processEngineConfiguration.isUsePrefixId()));
            }
            String annotationDeploymentKey = context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY;
            String deploymentIdFromDeploymentAnnotation = (String)this.getStore(context).get((Object)annotationDeploymentKey, String.class);
            if (deploymentIdFromDeploymentAnnotation != null) {
                TestHelper.annotationDeploymentTearDown(processEngine, deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
                this.getStore(context).remove((Object)annotationDeploymentKey);
            }
            AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), CleanTest.class).ifPresent(cleanTest -> this.removeDeployments(processEngine.getRepositoryService()));
            AbstractFlowableTestCase.cleanDeployments(processEngine);
            if (context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == lifecycleForClean && processEngineConfiguration.isUsingRelationalDatabase()) {
                this.cleanTestAndAssertAndEnsureCleanDb(context, processEngine);
            }
        }
        finally {
            if (isAsyncHistoryEnabled) {
                processEngineConfiguration.setAsyncHistoryEnabled(true);
                processEngineConfiguration.setHistoryManager(asyncHistoryManager);
            }
            processEngineConfiguration.getClock().reset();
        }
    }

    protected void cleanTestAndAssertAndEnsureCleanDb(ExtensionContext context, ProcessEngine processEngine) {
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), CleanTest.class).ifPresent(cleanTest -> this.removeDeployments(this.getProcessEngine(context).getRepositoryService()));
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> this.assertAndEnsureCleanDb(processEngine, context, (EnsureCleanDb)ensureCleanDb));
    }

    protected void assertAndEnsureCleanDb(ProcessEngine processEngine, ExtensionContext context, EnsureCleanDb ensureCleanDb) {
        this.logger.debug("verifying that db is clean after test");
        HashSet<String> tableNamesExcludedFromDbCleanCheck = new HashSet<String>(Arrays.asList(ensureCleanDb.excludeTables()));
        ManagementService managementService = processEngine.getManagementService();
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        Map<String, Long> tableCounts = managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(processEngineConfiguration.getDatabaseTablePrefix(), "");
            if (tableNamesExcludedFromDbCleanCheck.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            this.logger.error("\n");
            this.logger.error(outputMessage.toString());
            this.logger.info("dropping and recreating db");
            if (ensureCleanDb.dropDb()) {
                CommandExecutor commandExecutor = processEngineConfiguration.getCommandExecutor();
                CommandConfig config = new CommandConfig().transactionNotSupported();
                commandExecutor.execute(config, (Command)new Command<Object>(){

                    public Object execute(CommandContext commandContext) {
                        SchemaManager schemaManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getSchemaManager();
                        schemaManager.schemaDrop();
                        schemaManager.schemaCreate();
                        return null;
                    }
                });
            }
            if (!context.getExecutionException().isPresent()) {
                throw new AssertionError((Object)outputMessage.toString());
            }
        } else {
            this.logger.info("database was clean");
        }
    }

    protected void removeDeployments(RepositoryService repositoryService) {
        for (Deployment deployment : repositoryService.createDeploymentQuery().list()) {
            try {
                repositoryService.deleteDeployment(deployment.getId(), true);
            }
            catch (FlowableOptimisticLockingException flowableOptimisticLockingException) {
                this.logger.warn("Caught exception, retrying", (Throwable)flowableOptimisticLockingException);
                repositoryService.deleteDeployment(deployment.getId(), true);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return ProcessEngine.class.equals(parameterType) || parameterContext.isAnnotated(DeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        if (parameterContext.isAnnotated(DeploymentId.class)) {
            return this.getStore(context).get((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        }
        return this.getProcessEngine(context);
    }

    protected abstract ProcessEngine getProcessEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

