/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delete;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.impl.HistoricProcessInstanceQueryImpl;
import org.flowable.engine.impl.IdentityLinkQueryObject;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.service.impl.QueryVariableValue;

public class DeleteHistoricProcessInstancesUsingBatchesCmd
implements Command<String> {
    protected HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
    protected int batchSize;
    protected boolean sequential;
    protected String batchName;

    public DeleteHistoricProcessInstancesUsingBatchesCmd(HistoricProcessInstanceQueryImpl query, int batchSize, String batchName, boolean sequential) {
        this.historicProcessInstanceQuery = query;
        this.batchSize = batchSize;
        this.batchName = batchName;
        this.sequential = sequential;
    }

    public String execute(CommandContext commandContext) {
        if (this.historicProcessInstanceQuery == null) {
            throw new FlowableIllegalArgumentException("query is null");
        }
        if (this.batchSize <= 0) {
            throw new FlowableIllegalArgumentException("batchSize has to be larger than 0");
        }
        ProcessEngineConfigurationImpl engineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        long numberOfProcessInstancesToDelete = this.historicProcessInstanceQuery.count();
        ObjectNode batchConfiguration = engineConfiguration.getObjectMapper().createObjectNode();
        batchConfiguration.put("numberOfInstances", numberOfProcessInstancesToDelete);
        batchConfiguration.put("batchSize", this.batchSize);
        if (this.sequential) {
            batchConfiguration.put("sequential", true);
        }
        ObjectNode queryNode = batchConfiguration.putObject("query");
        this.populateQueryNode(queryNode, this.historicProcessInstanceQuery);
        for (HistoricProcessInstanceQueryImpl orQueryObject : this.historicProcessInstanceQuery.getOrQueryObjects()) {
            ObjectNode orQueryNode = queryNode.withArray("orQueryObjects").addObject();
            this.populateQueryNode(orQueryNode, orQueryObject);
        }
        String tenantId = this.historicProcessInstanceQuery.getTenantId();
        if (this.historicProcessInstanceQuery.isWithoutTenantId()) {
            tenantId = "";
        }
        Batch batch = batchService.createBatchBuilder().batchType("historicProcessDelete").tenantId(tenantId).searchKey(this.batchName).searchKey2(Authentication.getAuthenticatedUserId()).status("inProgress").batchDocumentJson(batchConfiguration.toString()).create();
        if (numberOfProcessInstancesToDelete > 0L) {
            long numberOfBatchParts = (long)Math.ceil((double)numberOfProcessInstancesToDelete / (double)this.batchSize);
            if (this.sequential) {
                this.createBatchPartsForSequentialExecution(engineConfiguration, batch, numberOfBatchParts);
            } else {
                this.createBatchPartsForParallelExecution(engineConfiguration, batch, numberOfBatchParts);
            }
        } else {
            batchService.completeBatch(batch.getId(), "completed");
        }
        return batch.getId();
    }

    protected void createBatchPartsForParallelExecution(ProcessEngineConfigurationImpl engineConfiguration, Batch batch, long numberOfBatchParts) {
        JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
        ManagementService managementService = engineConfiguration.getManagementService();
        int i = 0;
        while ((long)i < numberOfBatchParts) {
            BatchPart batchPart = managementService.createBatchPartBuilder(batch).type("computeDeleteProcessInstanceIds").searchKey(Integer.toString(i)).status("waiting").create();
            JobEntity job = jobService.createJob();
            job.setJobHandlerType("compute-delete-historic-process-ids");
            job.setJobHandlerConfiguration(batchPart.getId());
            jobService.createAsyncJob(job, false);
            jobService.scheduleAsyncJob(job);
            ++i;
        }
        TimerJobService timerJobService = engineConfiguration.getJobServiceConfiguration().getTimerJobService();
        TimerJobEntity timerJob = timerJobService.createTimerJob();
        timerJob.setJobType("timer");
        timerJob.setRevision(1);
        timerJob.setJobHandlerType("compute-delete-historic-process-status");
        timerJob.setJobHandlerConfiguration(batch.getId());
        BusinessCalendar businessCalendar = engineConfiguration.getBusinessCalendarManager().getBusinessCalendar("cycle");
        timerJob.setDuedate(businessCalendar.resolveDuedate(engineConfiguration.getBatchStatusTimeCycleConfig()));
        timerJob.setRepeat(engineConfiguration.getBatchStatusTimeCycleConfig());
        timerJobService.scheduleTimerJob(timerJob);
    }

    protected void createBatchPartsForSequentialExecution(ProcessEngineConfigurationImpl engineConfiguration, Batch batch, long numberOfBatchParts) {
        ManagementService managementService = engineConfiguration.getManagementService();
        BatchPart firstBatchPart = managementService.createBatchPartBuilder(batch).type("deleteProcess").searchKey(Integer.toString(0)).status("waiting").create();
        JobService jobService = engineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setJobHandlerType("delete-historic-processes-sequential");
        job.setJobHandlerConfiguration(firstBatchPart.getId());
        jobService.createAsyncJob(job, false);
        jobService.scheduleAsyncJob(job);
    }

    protected void populateQueryNode(ObjectNode queryNode, HistoricProcessInstanceQueryImpl query) {
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processInstanceId", (String)query.getProcessInstanceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processDefinitionId", (String)query.getProcessDefinitionId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessKey", (String)query.getBusinessKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessKeyLike", (String)query.getBusinessKeyLike());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessStatus", (String)query.getBusinessStatus());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"businessStatusLike", (String)query.getBusinessStatusLike());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"deploymentId", (String)query.getDeploymentId());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"deploymentIds", query.getDeploymentIds());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"finished", (boolean)query.isFinished());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"unfinished", (boolean)query.isUnfinished());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"deleted", (boolean)query.isDeleted());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"notDeleted", (boolean)query.isNotDeleted());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedBy", (String)query.getStartedBy());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"superProcessInstanceId", (String)query.getSuperProcessInstanceId());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"excludeSubprocesses", (boolean)query.isExcludeSubprocesses());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"processDefinitionKeyIn", query.getProcessDefinitionKeyIn());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"processKeyNotIn", query.getProcessKeyNotIn());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedBefore", (Date)query.getStartedBefore());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"startedAfter", (Date)query.getStartedAfter());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"finishedBefore", (Date)query.getFinishedBefore());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"finishedAfter", (Date)query.getFinishedAfter());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processDefinitionKey", (String)query.getProcessDefinitionKey());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processDefinitionCategory", (String)query.getProcessDefinitionCategory());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processDefinitionName", (String)query.getProcessDefinitionName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"processDefinitionVersion", (Integer)query.getProcessDefinitionVersion());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"processInstanceIds", query.getProcessInstanceIds());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"activeActivityId", (String)query.getActiveActivityId());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"activeActivityIds", query.getActiveActivityIds());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"involvedUser", (String)query.getInvolvedUser());
        this.putIdentityLinkQuery(queryNode, "involvedUserIdentityLink", query.getInvolvedUserIdentityLink());
        AsyncHistoryJsonUtil.putIfNotNullOrEmpty((ObjectNode)queryNode, (String)"involvedGroups", query.getInvolvedGroups());
        this.putIdentityLinkQuery(queryNode, "involvedGroupIdentityLink", query.getInvolvedGroupIdentityLink());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withJobException", (boolean)query.isWithJobException());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"tenantId", (String)query.getTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"tenantIdLike", (String)query.getTenantIdLike());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withoutTenantId", (boolean)query.isWithoutTenantId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"name", (String)query.getName());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"nameLike", (String)query.getNameLike());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"nameLikeIgnoreCase", (String)query.getNameLikeIgnoreCase());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"callbackId", (String)query.getCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"callbackType", (String)query.getCallbackType());
        AsyncHistoryJsonUtil.putIfTrue((ObjectNode)queryNode, (String)"withoutCallbackId", (boolean)query.isWithoutCallbackId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"referenceId", (String)query.getReferenceId());
        AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)queryNode, (String)"referenceType", (String)query.getReferenceType());
        for (QueryVariableValue queryVariableValue : query.getQueryVariableValues()) {
            ArrayNode queryVariablesArrayNode = queryNode.withArray("queryVariableValues");
            this.populateQueryVariableValue(queryVariablesArrayNode, queryVariableValue);
        }
    }

    protected void putIdentityLinkQuery(ObjectNode queryNode, String key, IdentityLinkQueryObject linkQueryObject) {
        if (linkQueryObject != null) {
            ObjectNode linkNode = queryNode.putObject(key);
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"userId", (String)linkQueryObject.getUserId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"groupId", (String)linkQueryObject.getGroupId());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)linkNode, (String)"type", (String)linkQueryObject.getType());
        }
    }

    protected void populateQueryVariableValue(ArrayNode queryVariablesArrayNode, QueryVariableValue variableValue) {
        if (variableValue != null) {
            ObjectNode variableNode = queryVariablesArrayNode.addObject();
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"name", (String)variableValue.getName());
            variableNode.put("operator", variableValue.getOperator());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"textValue", (String)variableValue.getTextValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"textValue2", (String)variableValue.getTextValue2());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"longValue", (Long)variableValue.getLongValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"doubleValue", (Double)variableValue.getDoubleValue());
            AsyncHistoryJsonUtil.putIfNotNull((ObjectNode)variableNode, (String)"type", (String)variableValue.getType());
            AsyncHistoryJsonUtil.putIfTrue((ObjectNode)variableNode, (String)"local", (boolean)variableValue.isLocal());
        }
    }
}

