/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.el.FixedValue;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.delegate.DelegateTask;

public class DelegateHelper {
    public static void leaveDelegate(DelegateExecution delegateExecution) {
        CommandContextUtil.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)delegateExecution, true);
    }

    public static void leaveDelegate(DelegateExecution delegateExecution, String sequenceFlowId) {
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        FlowElement flowElement = process.getFlowElement(sequenceFlowId);
        if (!(flowElement instanceof SequenceFlow)) {
            throw new FlowableException(sequenceFlowId + " does not match a sequence flow for " + delegateExecution);
        }
        delegateExecution.setCurrentFlowElement(flowElement);
        CommandContextUtil.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)delegateExecution, false);
    }

    public static BpmnModel getBpmnModel(DelegateExecution execution) {
        if (execution == null) {
            throw new FlowableException("Null execution passed");
        }
        return ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId());
    }

    public static FlowElement getFlowElement(DelegateExecution execution) {
        BpmnModel bpmnModel = DelegateHelper.getBpmnModel(execution);
        FlowElement flowElement = bpmnModel.getFlowElement(execution.getCurrentActivityId());
        if (flowElement == null) {
            throw new FlowableException("Could not find a FlowElement for activityId " + execution.getCurrentActivityId() + " in " + execution);
        }
        return flowElement;
    }

    public static boolean isExecutingExecutionListener(DelegateExecution execution) {
        return execution.getCurrentFlowableListener() != null;
    }

    public static Map<String, List<ExtensionElement>> getExtensionElements(DelegateExecution execution) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerExtensionElements(execution);
        }
        return DelegateHelper.getFlowElementExtensionElements(execution);
    }

    public static Map<String, List<ExtensionElement>> getFlowElementExtensionElements(DelegateExecution execution) {
        return DelegateHelper.getFlowElement(execution).getExtensionElements();
    }

    public static Map<String, List<ExtensionElement>> getListenerExtensionElements(DelegateExecution execution) {
        return execution.getCurrentFlowableListener().getExtensionElements();
    }

    public static List<FieldExtension> getFields(DelegateExecution execution) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerFields(execution);
        }
        return DelegateHelper.getFlowElementFields(execution);
    }

    public static List<FieldExtension> getFlowElementFields(DelegateExecution execution) {
        FlowElement flowElement = DelegateHelper.getFlowElement(execution);
        if (flowElement instanceof TaskWithFieldExtensions) {
            return ((TaskWithFieldExtensions)flowElement).getFieldExtensions();
        }
        return new ArrayList<FieldExtension>();
    }

    public static List<FieldExtension> getListenerFields(DelegateExecution execution) {
        return execution.getCurrentFlowableListener().getFieldExtensions();
    }

    public static FieldExtension getField(DelegateExecution execution, String fieldName) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerField(execution, fieldName);
        }
        return DelegateHelper.getFlowElementField(execution, fieldName);
    }

    public static FieldExtension getFlowElementField(DelegateExecution execution, String fieldName) {
        List<FieldExtension> fieldExtensions = DelegateHelper.getFlowElementFields(execution);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static FieldExtension getListenerField(DelegateExecution execution, String fieldName) {
        List<FieldExtension> fieldExtensions = DelegateHelper.getListenerFields(execution);
        if (fieldExtensions == null || fieldExtensions.size() == 0) {
            return null;
        }
        for (FieldExtension fieldExtension : fieldExtensions) {
            if (fieldExtension.getFieldName() == null || !fieldExtension.getFieldName().equals(fieldName)) continue;
            return fieldExtension;
        }
        return null;
    }

    public static Expression createExpressionForField(FieldExtension fieldExtension) {
        if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) {
            ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration().getExpressionManager();
            return expressionManager.createExpression(fieldExtension.getExpression());
        }
        return new FixedValue(fieldExtension.getStringValue());
    }

    public static Expression getFieldExpression(DelegateExecution execution, String fieldName) {
        if (DelegateHelper.isExecutingExecutionListener(execution)) {
            return DelegateHelper.getListenerFieldExpression(execution, fieldName);
        }
        return DelegateHelper.getFlowElementFieldExpression(execution, fieldName);
    }

    public static Expression getFieldExpression(DelegateTask task, String fieldName) {
        String eventHandlerId = task.getEventHandlerId();
        if (eventHandlerId != null && task.getProcessDefinitionId() != null) {
            List fieldExtensions;
            Process process = ProcessDefinitionUtil.getProcess(task.getProcessDefinitionId());
            UserTask userTask = (UserTask)process.getFlowElementMap().get(task.getTaskDefinitionKey());
            FlowableListener flowableListener = null;
            for (FlowableListener f : userTask.getTaskListeners()) {
                if (f.getId() == null || !f.getId().equals(eventHandlerId)) continue;
                flowableListener = f;
            }
            if (flowableListener != null && (fieldExtensions = flowableListener.getFieldExtensions()) != null && fieldExtensions.size() > 0) {
                for (FieldExtension fieldExtension : fieldExtensions) {
                    if (!fieldName.equals(fieldExtension.getFieldName())) continue;
                    return DelegateHelper.createExpressionForField(fieldExtension);
                }
            }
        }
        return null;
    }

    public static Expression getFlowElementFieldExpression(DelegateExecution execution, String fieldName) {
        FieldExtension fieldExtension = DelegateHelper.getFlowElementField(execution, fieldName);
        if (fieldExtension != null) {
            return DelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }

    public static Expression getListenerFieldExpression(DelegateExecution execution, String fieldName) {
        FieldExtension fieldExtension = DelegateHelper.getListenerField(execution, fieldName);
        if (fieldExtension != null) {
            return DelegateHelper.createExpressionForField(fieldExtension);
        }
        return null;
    }
}

