/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.common.spring.SpringTransactionContextFactory;
import org.flowable.common.spring.SpringTransactionInterceptor;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.EventRegistryEngines;
import org.flowable.eventregistry.impl.cfg.StandaloneEventRegistryEngineConfiguration;
import org.flowable.eventregistry.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.eventregistry.spring.management.DefaultSpringEventRegistryChangeDetectionExecutor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringEventRegistryEngineConfiguration
extends EventRegistryEngineConfiguration
implements SpringEngineConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    protected Collection<AutoDeploymentStrategy<EventRegistryEngine>> deploymentStrategies = new ArrayList<AutoDeploymentStrategy<EventRegistryEngine>>();
    protected volatile boolean running = false;
    protected List<String> enginesBuild = new ArrayList<String>();
    protected final Object lifeCycleMonitor = new Object();

    public SpringEventRegistryEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.enableEventRegistryChangeDetectionAfterEngineCreate = false;
        this.deploymentStrategies.add((AutoDeploymentStrategy<EventRegistryEngine>)new DefaultAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<EventRegistryEngine>)new SingleResourceAutoDeploymentStrategy());
        this.deploymentStrategies.add((AutoDeploymentStrategy<EventRegistryEngine>)new ResourceParentFolderAutoDeploymentStrategy());
    }

    public EventRegistryEngine buildEventRegistryEngine() {
        EventRegistryEngine eventRegistryEngine = super.buildEventRegistryEngine();
        EventRegistryEngines.setInitialized((boolean)true);
        this.enginesBuild.add(eventRegistryEngine.getName());
        return eventRegistryEngine;
    }

    public void initBeans() {
        if (this.beans == null) {
            this.beans = new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext);
        }
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringEventRegistryEngineConfiguration, use " + StandaloneEventRegistryEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    protected void autoDeployResources(EventRegistryEngine eventRegistryEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy<EventRegistryEngine> strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentName, this.deploymentResources, (Object)eventRegistryEngine);
        }
    }

    public EventRegistryEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return (EventRegistryEngineConfiguration)super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return (EventRegistryEngineConfiguration)super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy<EventRegistryEngine> getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy<EventRegistryEngine> result = new AutoDeploymentStrategy<EventRegistryEngine>();
        for (AutoDeploymentStrategy<EventRegistryEngine> strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }

    public Collection<AutoDeploymentStrategy<EventRegistryEngine>> getDeploymentStrategies() {
        return this.deploymentStrategies;
    }

    public void setDeploymentStrategies(Collection<AutoDeploymentStrategy<EventRegistryEngine>> deploymentStrategies) {
        this.deploymentStrategies = deploymentStrategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                this.enginesBuild.forEach(name -> {
                    EventRegistryEngine eventRegistryEngine = EventRegistryEngines.getEventRegistryEngine((String)name);
                    eventRegistryEngine.handleDeployedChannelDefinitions();
                    this.createAndInitEventRegistryChangeDetectionExecutor();
                    this.autoDeployResources(eventRegistryEngine);
                });
                this.running = true;
            }
        }
    }

    public void initChangeDetectionExecutor() {
        if (this.eventRegistryChangeDetectionExecutor == null) {
            this.eventRegistryChangeDetectionExecutor = new DefaultSpringEventRegistryChangeDetectionExecutor(this.eventRegistryChangeDetectionInitialDelayInMs, this.eventRegistryChangeDetectionDelayInMs);
        }
    }

    protected void createAndInitEventRegistryChangeDetectionExecutor() {
        if (this.enableEventRegistryChangeDetection && this.eventRegistryChangeDetectionExecutor != null) {
            this.eventRegistryChangeDetectionExecutor.setEventRegistryChangeDetectionManager(this.eventRegistryChangeDetectionManager);
            this.eventRegistryChangeDetectionExecutor.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifeCycleMonitor;
        synchronized (object) {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return super.getPhase() - 20;
    }
}

