/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.rabbit;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;

public class RabbitChannelMessageListenerAdapter
implements MessageListener {
    protected Collection<String> stringContentTypes;
    protected EventRegistry eventRegistry;
    protected InboundChannelModel inboundChannelModel;

    public RabbitChannelMessageListenerAdapter(EventRegistry eventRegistry, InboundChannelModel inboundChannelModel) {
        this.eventRegistry = eventRegistry;
        this.inboundChannelModel = inboundChannelModel;
        this.stringContentTypes = new HashSet<String>();
        this.stringContentTypes.add("application/json");
        this.stringContentTypes.add("text/x-json");
        this.stringContentTypes.add("text/plain");
        this.stringContentTypes.add("application/xml");
    }

    public void onMessage(Message message) {
        String contentType;
        byte[] body = message.getBody();
        MessageProperties messageProperties = message.getMessageProperties();
        String string = contentType = messageProperties != null ? messageProperties.getContentType() : null;
        String rawEvent = body == null ? null : (this.stringContentTypes.contains(contentType) ? new String(body, StandardCharsets.UTF_8) : Base64.getEncoder().encodeToString(body));
        this.eventRegistry.eventReceived(this.inboundChannelModel, rawEvent);
    }

    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public void setEventRegistry(EventRegistry eventRegistry) {
        this.eventRegistry = eventRegistry;
    }

    public InboundChannelModel getInboundChannelModel() {
        return this.inboundChannelModel;
    }

    public void setInboundChannelModel(InboundChannelModel inboundChannelModel) {
        this.inboundChannelModel = inboundChannelModel;
    }

    public Collection<String> getStringContentTypes() {
        return this.stringContentTypes;
    }

    public void setStringContentTypes(Collection<String> stringContentTypes) {
        this.stringContentTypes = stringContentTypes;
    }
}

