/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.eventregistry.impl.parser.ChannelDefinitionParse;
import org.flowable.eventregistry.impl.parser.EventDefinitionParse;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;

public class ParsedDeployment {
    protected EventDeploymentEntity deploymentEntity;
    protected List<EventDefinitionEntity> eventDefinitions;
    protected List<ChannelDefinitionEntity> channelDefinitions;
    protected Map<EventDefinitionEntity, EventDefinitionParse> mapEventDefinitionsToParses;
    protected Map<EventDefinitionEntity, EventResourceEntity> mapEventDefinitionsToResources;
    protected Map<ChannelDefinitionEntity, ChannelDefinitionParse> mapChannelDefinitionsToParses;
    protected Map<ChannelDefinitionEntity, EventResourceEntity> mapChannelDefinitionsToResources;

    public ParsedDeployment(EventDeploymentEntity entity, List<EventDefinitionEntity> eventDefinitions, List<ChannelDefinitionEntity> channelDefinitions, Map<EventDefinitionEntity, EventDefinitionParse> mapEventDefinitionsToParses, Map<EventDefinitionEntity, EventResourceEntity> mapEventDefinitionsToResources, Map<ChannelDefinitionEntity, ChannelDefinitionParse> mapChannelDefinitionsToParses, Map<ChannelDefinitionEntity, EventResourceEntity> mapChannelDefinitionsToResources) {
        this.deploymentEntity = entity;
        this.eventDefinitions = eventDefinitions;
        this.channelDefinitions = channelDefinitions;
        this.mapEventDefinitionsToParses = mapEventDefinitionsToParses;
        this.mapEventDefinitionsToResources = mapEventDefinitionsToResources;
        this.mapChannelDefinitionsToParses = mapChannelDefinitionsToParses;
        this.mapChannelDefinitionsToResources = mapChannelDefinitionsToResources;
    }

    public EventDeploymentEntity getDeployment() {
        return this.deploymentEntity;
    }

    public List<EventDefinitionEntity> getAllEventDefinitions() {
        return this.eventDefinitions;
    }

    public List<ChannelDefinitionEntity> getAllChannelDefinitions() {
        return this.channelDefinitions;
    }

    public EventResourceEntity getResourceForEventDefinition(EventDefinitionEntity eventDefinition) {
        return this.mapEventDefinitionsToResources.get(eventDefinition);
    }

    public EventDefinitionParse getEventDefinitionParseForEventDefinition(EventDefinitionEntity formDefinition) {
        return this.mapEventDefinitionsToParses.get(formDefinition);
    }

    public EventModel getEventModelForEventDefinition(EventDefinitionEntity eventDefinition) {
        EventDefinitionParse parse = this.getEventDefinitionParseForEventDefinition(eventDefinition);
        return parse == null ? null : parse.getEventModel();
    }

    public EventResourceEntity getResourceForChannelDefinition(ChannelDefinitionEntity channelDefinition) {
        return this.mapChannelDefinitionsToResources.get(channelDefinition);
    }

    public ChannelDefinitionParse getChannelDefinitionParseForChannelDefinition(ChannelDefinitionEntity channelDefinition) {
        return this.mapChannelDefinitionsToParses.get(channelDefinition);
    }

    public ChannelModel getChannelModelForChannelDefinition(ChannelDefinitionEntity channelDefinition) {
        ChannelDefinitionParse parse = this.getChannelDefinitionParseForChannelDefinition(channelDefinition);
        return parse == null ? null : parse.getChannelModel();
    }
}

