/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.serialization;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.InboundEventDeserializer;
import org.w3c.dom.Document;

public class StringToXmlDocumentDeserializer
implements InboundEventDeserializer<Document> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document deserialize(String rawEvent) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(rawEvent.getBytes(StandardCharsets.UTF_8));){
                Document document = documentBuilder.parse(inputStream);
                return document;
            }
        }
        catch (Exception e) {
            throw new FlowableException("Could not deserialize event to xml", (Throwable)e);
        }
    }
}

