/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.management;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionExecutor;
import org.flowable.eventregistry.api.management.EventRegistryChangeDetectionManager;
import org.flowable.eventregistry.impl.management.EventRegistryChangeDetectionRunnable;

public class DefaultEventRegistryChangeDetectionExecutor
implements EventRegistryChangeDetectionExecutor {
    protected EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager;
    protected long initialDelayInMs;
    protected long delayInMs;
    protected ScheduledExecutorService scheduledExecutorService;
    protected String threadName = "flowable-event-registry-change-detector-%d";
    protected Runnable changeDetectionRunnable;

    public DefaultEventRegistryChangeDetectionExecutor(EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager, long initialDelayInMs, long delayInMs) {
        this.eventRegistryChangeDetectionManager = eventRegistryChangeDetectionManager;
        this.initialDelayInMs = initialDelayInMs;
        this.delayInMs = delayInMs;
    }

    public void initialize() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern(this.threadName).build());
        this.changeDetectionRunnable = this.createChangeDetectionRunnable();
        this.scheduledExecutorService.scheduleAtFixedRate(this.changeDetectionRunnable, this.initialDelayInMs, this.delayInMs, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }

    protected Runnable createChangeDetectionRunnable() {
        return new EventRegistryChangeDetectionRunnable(this.eventRegistryChangeDetectionManager);
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Runnable getChangeDetectionRunnable() {
        return this.changeDetectionRunnable;
    }

    public void setChangeDetectionRunnable(Runnable changeDetectionRunnable) {
        this.changeDetectionRunnable = changeDetectionRunnable;
    }

    public EventRegistryChangeDetectionManager getEventRegistryChangeDetectionManager() {
        return this.eventRegistryChangeDetectionManager;
    }

    public void setEventRegistryChangeDetectionManager(EventRegistryChangeDetectionManager eventRegistryChangeDetectionManager) {
        this.eventRegistryChangeDetectionManager = eventRegistryChangeDetectionManager;
    }
}

