/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.flowable.eventregistry.impl.deployer.ParsedDeployment;
import org.flowable.eventregistry.impl.parser.ChannelDefinitionParse;
import org.flowable.eventregistry.impl.parser.ChannelDefinitionParseFactory;
import org.flowable.eventregistry.impl.parser.EventDefinitionParse;
import org.flowable.eventregistry.impl.parser.EventDefinitionParseFactory;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    public static final String[] EVENT_RESOURCE_SUFFIXES = new String[]{"event"};
    public static final String[] CHANNEL_RESOURCE_SUFFIXES = new String[]{"channel"};
    protected EventDeploymentEntity deployment;
    protected EventDefinitionParseFactory eventDefinitionParseFactory;
    protected ChannelDefinitionParseFactory channelDefinitionParseFactory;

    public ParsedDeploymentBuilder(EventDeploymentEntity deployment, EventDefinitionParseFactory eventDefinitionParseFactory, ChannelDefinitionParseFactory channelDefinitionParseFactory) {
        this.deployment = deployment;
        this.eventDefinitionParseFactory = eventDefinitionParseFactory;
        this.channelDefinitionParseFactory = channelDefinitionParseFactory;
    }

    public ParsedDeployment build() {
        ArrayList<EventDefinitionEntity> eventDefinitions = new ArrayList<EventDefinitionEntity>();
        ArrayList<ChannelDefinitionEntity> channelDefinitions = new ArrayList<ChannelDefinitionEntity>();
        LinkedHashMap<EventDefinitionEntity, EventDefinitionParse> eventDefinitionToParseMap = new LinkedHashMap<EventDefinitionEntity, EventDefinitionParse>();
        LinkedHashMap<EventDefinitionEntity, EventResourceEntity> eventDefinitionToResourceMap = new LinkedHashMap<EventDefinitionEntity, EventResourceEntity>();
        LinkedHashMap<ChannelDefinitionEntity, ChannelDefinitionParse> channelDefinitionToParseMap = new LinkedHashMap<ChannelDefinitionEntity, ChannelDefinitionParse>();
        LinkedHashMap<ChannelDefinitionEntity, EventResourceEntity> channelDefinitionToResourceMap = new LinkedHashMap<ChannelDefinitionEntity, EventResourceEntity>();
        for (EventResourceEntity resource : this.deployment.getResources().values()) {
            Object parse;
            if (this.isEventResource(resource.getName())) {
                LOGGER.debug("Processing Event definition resource {}", (Object)resource.getName());
                parse = this.createEventParseFromResource(resource);
                for (EventDefinitionEntity eventDefinition : ((EventDefinitionParse)parse).getEventDefinitions()) {
                    eventDefinitions.add(eventDefinition);
                    eventDefinitionToParseMap.put(eventDefinition, (EventDefinitionParse)parse);
                    eventDefinitionToResourceMap.put(eventDefinition, resource);
                }
                continue;
            }
            if (!this.isChannelResource(resource.getName())) continue;
            LOGGER.debug("Processing Channel definition resource {}", (Object)resource.getName());
            parse = this.createChannelParseFromResource(resource);
            for (ChannelDefinitionEntity channelDefinition : ((ChannelDefinitionParse)parse).getChannelDefinitions()) {
                channelDefinitions.add(channelDefinition);
                channelDefinitionToParseMap.put(channelDefinition, (ChannelDefinitionParse)parse);
                channelDefinitionToResourceMap.put(channelDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, eventDefinitions, channelDefinitions, eventDefinitionToParseMap, eventDefinitionToResourceMap, channelDefinitionToParseMap, channelDefinitionToResourceMap);
    }

    protected EventDefinitionParse createEventParseFromResource(EventResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        EventDefinitionParse eventParse = this.eventDefinitionParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        eventParse.execute(CommandContextUtil.getEventRegistryConfiguration());
        return eventParse;
    }

    protected ChannelDefinitionParse createChannelParseFromResource(EventResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        ChannelDefinitionParse eventParse = this.channelDefinitionParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        eventParse.execute(CommandContextUtil.getEventRegistryConfiguration());
        return eventParse;
    }

    protected boolean isEventResource(String resourceName) {
        for (String suffix : EVENT_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean isChannelResource(String resourceName) {
        for (String suffix : CHANNEL_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

