/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.flowable.editor.form.converter.FormJsonConverter;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.io.ResourceStreamSource;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.SimpleFormModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormDefinitionParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormDefinitionParse.class);
    protected String name;
    protected boolean validateSchema = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected SimpleFormModel formModel;
    protected String targetNamespace;
    protected FormDeploymentEntity deployment;
    protected List<FormDefinitionEntity> formDefinitions = new ArrayList<FormDefinitionEntity>();

    public FormDefinitionParse deployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public FormDefinitionParse execute(FormEngineConfiguration formEngineConfig) {
        String encoding = formEngineConfig.getXmlEncoding();
        FormJsonConverter converter = new FormJsonConverter();
        try (InputStreamReader in = this.newInputStreamReaderForSource(encoding);){
            String formJson = IOUtils.toString((Reader)in);
            this.formModel = converter.convertToFormModel(formJson);
            if (this.formModel != null && this.formModel.getFields() != null) {
                FormDefinitionEntity formDefinitionEntity = (FormDefinitionEntity)CommandContextUtil.getFormEngineConfiguration().getFormDefinitionEntityManager().create();
                formDefinitionEntity.setKey(this.formModel.getKey());
                formDefinitionEntity.setName(this.formModel.getName());
                formDefinitionEntity.setResourceName(this.name);
                formDefinitionEntity.setDeploymentId(this.deployment.getId());
                formDefinitionEntity.setDescription(this.formModel.getDescription());
                this.formDefinitions.add(formDefinitionEntity);
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form definition JSON", (Throwable)e);
        }
        return this;
    }

    private InputStreamReader newInputStreamReaderForSource(String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new InputStreamReader(this.streamSource.getInputStream(), encoding);
        }
        return new InputStreamReader(this.streamSource.getInputStream());
    }

    public FormDefinitionParse name(String name) {
        this.name = name;
        return this;
    }

    public FormDefinitionParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public FormDefinitionParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public FormDefinitionParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("malformed url: " + url, (Throwable)e);
        }
    }

    public FormDefinitionParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public FormDefinitionParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new FlowableException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public FormDefinitionParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public List<FormDefinitionEntity> getFormDefinitions() {
        return this.formDefinitions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public FormDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(FormDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public SimpleFormModel getFormModel() {
        return this.formModel;
    }

    public void setFormModel(SimpleFormModel formModel) {
        this.formModel = formModel;
    }
}

