/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.spring.autodeployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.flowable.form.api.FormDeploymentBuilder;
import org.flowable.form.engine.FormEngine;
import org.springframework.core.io.Resource;

public abstract class AbstractFormAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<FormEngine> {
    public AbstractFormAutoDeploymentStrategy() {
    }

    public AbstractFormAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(FormEngine engine, String deploymentNameHint) {
        return engine.getFormEngineConfiguration().getLockManager(this.determineLockName(deploymentNameHint));
    }

    protected void addResource(Resource resource, FormDeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, FormDeploymentBuilder deploymentBuilder) {
        try (InputStream inputStream = resource.getInputStream();){
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read resource " + resource, ex);
        }
    }
}

