/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.persistence.entity.PrivilegeEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class CreatePrivilegeCmd
implements Command<Privilege>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected IdmEngineConfiguration idmEngineConfiguration;
    protected String name;

    public CreatePrivilegeCmd(String name, IdmEngineConfiguration idmEngineConfiguration) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Privilege name is null");
        }
        this.name = name;
        this.idmEngineConfiguration = idmEngineConfiguration;
    }

    public Privilege execute(CommandContext commandContext) {
        long count = this.idmEngineConfiguration.getPrivilegeEntityManager().createNewPrivilegeQuery().privilegeName(this.name).count();
        if (count > 0L) {
            throw new FlowableIllegalArgumentException("Provided privilege name already exists");
        }
        PrivilegeEntity entity = (PrivilegeEntity)CommandContextUtil.getPrivilegeEntityManager(commandContext).create();
        entity.setName(this.name);
        CommandContextUtil.getPrivilegeEntityManager(commandContext).insert(entity);
        return entity;
    }
}

